/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/


/**
 * Purpose: The goal of this class is to minimize the repeating String manipulation
 * code written when readining in parameters. The methods here are meant to be
 * highly repeatable and easy to use. All methods assume they are being given a
 * string with the end goal of returning an array to iterate through.
 * Note: Assumed that all lists are separated by commas and/or newlines.
 * All whitespace is eliminated.
 */
package com.urbancode.air.plugin.datastage;
public class TextBoxParser {

    // Standardizes file name, confirms existance, and returns file text if exists
    // Note: Will not work on Z and I OSs
    public String retrieveFileText(String file) {
        def fileText
        File f = new File(file)
        // Check if the given path exists
        if (f.isFile()) {
            // Retrieve file text
            fileText =  f.getText('UTF-8')
        }
        else {
            // Else, the given text isn't a file
            fileText = file
        }
        return fileText
    }

    // Reads info, checks if input is a file, gets file text if it is
    // Otherwise, parses string as is into a String[]
    // Use Case: Enable user to enter either filename or string list as input for a
    // textAreaBox.
    public String[] readFileorTextString(String input) {
        if (input.endsWith(".txt")) {
            input = retrieveFileText(input)
        }
        return text2StringArray(input)
    }

    // Reads info, checks if input is a file, gets file text if it is
    // Otherwise, parses string as is into a Long[]
    // Use Case: Enable user to enter either filename or Long list as input for a
    // textAreaBox.
    public Long[] readFileorTextLong(String input) {
        text = retrieveFileText(input)
        return text2LongArray(text)
    }

    // Takes a string, separates it based on commas and new lines
    // Then places each new element into a String array
    // Use Case: Parse names, IP Addresses, and when any character can be entered
    public String[] text2StringArray(String input) {
        def output
        if (input) {
            output = input.replaceAll('\n', ',').split(',').findAll{
                it && it.trim().size() > 0} as String[]
            output = output.collect {it.trim()}
        }
        return output
    }

    // Takes a string, separates it based on commas and new lines
    // Then places each new element into a Long array
    // Use Case: Parse ports and other integers (negative or positive)
    public Long[] text2LongArray(String input) {
        def output = []
        if (input) {
            def tempStringArray = []
            tempStringArray = input.replaceAll('\n', ',').split(',').findAll{
                it && it.trim().size() > 0} as String[]
            tempStringArray.each {it.trim()}

            for (temp in tempStringArray){
                try {
                    output.add(Long.parseLong(temp.replaceAll("\\s","")))
                } catch (Exception ex) {
                    throw new Exception("You entered an invalid character in an Integer only field. Please ensure integers and commas are the only characters entered.")
                }
            }
        }
        return output
    }
}