/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.datastage.DataStageHelper;
import com.urbancode.air.plugin.datastage.TextBoxParser;

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

DataStageHelper helper = new DataStageHelper()
TextBoxParser tBox = new TextBoxParser()

def workDir = new File(".")
def ch = new CommandHelper(workDir)

// dscmdexport Properties
def authfile    = props['authfile']
def domain      = props['domain']
def dsScriptPath = props['dsScriptPath']
def hostname    = props['hostname']
def username    = props['username']
def password    = props['password']
def projects    = tBox.readFileorTextString(props['project'])
def pathname    = props['pathname']
if (!pathname) {
    pathname = workDir.getCanonicalPath()
}
def verbose     = Boolean.parseBoolean(props['verbose'])

// Initialize the basic arguments that are the same across all exports
final def isWindows = System.getProperty('os.name').contains("Windows")

// Construct and find the location of the DataStage script
def dsScript = isWindows ? "dscmdexport.exe" : "dscmdexport.sh"
def fullScriptPath = dsScriptPath + File.separator + dsScript
File scriptFile = new File(fullScriptPath)
if (!scriptFile.isFile()) {
    throw new Exception ("${fullScriptPath} does not exist!")
}

// Create and run command line that is sepcific to the project
def exitVals = []
println "Export Projects : " + projects.toString()
for (project in projects) {
    def args = [fullScriptPath]

    if (authfile) {
        File authfileFile = new File(authfile)
        if (!authfileFile.isFile()) {
            throw new Exception ("${authfile} does not exist!")
        }
        args << "/AF=${authfile}"
    }
    if (domain) {
        args << "/D=${domain}"
    }
    if (hostname) {
        args << "/H=${hostname}"
    }
    if (username) {
        args << "/U=${username}"
    }
    if (password) {
        args << "/P=${password}"
    }

    if (project) {
        args << "${project}"
    }

    args << pathname + File.separator + project + ".dsx"

    if (verbose) {
        args << "/V"
    }

    // RUN COMMAND
    def ignoredFiles = ch.runCommand("Starting dscmdexport command...", args, helper.getSystemOutput)
    apTool.setOutputProperty("${project}.ignoredFiles", (String)ignoredFiles)

    // Print system output
    def output = helper.systemOutput
    println "DataStage System output..."
    println output

    //////// Parse output and return sensable output ////////

    // Export failed before it began
    if (output.contains("Failed to attach to the project")){
        println "Failed to reach DataStage Server with the given properties. Please confirm:"
        println "\t - Domain:Port \t - Username"
        println "\t - Password \t - Project"
        println "\t - Agent has admin privileges"
        println "\t - InfoSphere Server is up"
        exitVals << 1
    }
    // Export failed during .dsx creation
    else if (output.contains("dscmdexport failed")) {
        println "Export failed during the creation of the .dsx file."
        println "This is likely an error with the chosen DataStage project."
        println "Note: An .dsx file has been created in the working directory, but it is incomplete!"
        exitVals << 1
    }
    // Export succeeded
    else if (output.contains("DSExport ended at:")) {
        println "Export is successful!"
        exitVals << 0
    }
    // Catch all
    else {
        println "Unknown dscmdexport failure. Please review the error file for a full report."
        exitVals << 1
    }

    println "==========================================================================================="
}

apTool.setOutputProperties()
// Describe where additional error output can be found
if (exitVals.contains(1)) {
    print "Detailed error output created by the DataStage software can be found here: "
    if (isWindows) {
        println "'C:\\Users\\<USER_NAME>\\ds_logs\\*'"
    }
    else {
        println "'/home/<USER_NAME>/ds_logs/*'"
    }
    System.exit(1)
}
