/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.datastage.TextBoxParser;

def apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

TextBoxParser tBox = new TextBoxParser()

final def workDir = new File('.')
def ch = new CommandHelper(workDir)

 // dscc Properties
def authfile    = props['authfile']
def domain      = props['domain']
def hostname    = props['hostname']
def username    = props['username']
def password    = props['password']
def project     = props['project']
def compChoice  = props['compChoice']
def name        = props['name']
def force       = Boolean.parseBoolean(props['force'])
def ouc         = Boolean.parseBoolean(props['ouc'])
def rd          = props['rd']
def dsScriptPath = props['dsScriptPath']

final def isWindows = System.getProperty('os.name').contains("Windows")

// Construct and find the location of the DataStage script
def dsScript = isWindows ? "dscc.exe" : "dscc.sh"
def fullScriptPath = dsScriptPath + File.separator + dsScript
File scriptFile = new File(fullScriptPath)
if (!scriptFile.isFile()) {
    throw new Exception ("${fullScriptPath} does not exist!")
}

// Construct the dscc command
def args = [fullScriptPath]
if (authfile) {
    File authfileFile = new File(authfile)
    if (!authfileFile.isFile()) {
        throw new Exception ("${authfile} does not exist!")
    }
    args << "/AF=${authfile}"
}
args << "-D"
args << "${domain}"
if (hostname) {
    args << "-H"
args << "${hostname}"
}
args << "-U"
args << "${username}"
args << "-P"
args << "${password}"
args << "${project}"
if (compChoice == "JOB") {
    args << "-J"
}
else (compChoice == "ROUTINE"){
    args << "-R"
}
args << "${name}"

if (force) {
    args << "-F"
}
if (ouc) {
    args << "-OUC"
}
if (rd) {
    args << "-RD"
    args << "${rd}"
}
args << "-qs"
args << "*"
args << "-qspa"

def exitCode = ch.runCommand("Running dscc compile command...", args)

System.exit(exitCode)
