/**
* Licensed Materials - Property of IBM* and/or HCL**
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

package com.urbancode.air.plugin.datastage;
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.CommandHelper;

public class DataStageHelper {


    public DataStageHelper() {
    }

    // Confirm each file ends with .dsx or .xml
    public void checkExtensions(String ... files) {
        if (files) {
            for (file in files) {
                if (!file.endsWith(".dsx") && !file.endsWith(".xml")) {
                    throw new Exception("${file} does not end with .dsx or .xml. All files must end with one of these two extensions.")
                }
            }
        }
        else {
            println "No files were given for extension checks."
        }
    }

    // Confirm each file ends with .dsx
    public void checkDSXExtensions(String ... files) {
        if (files) {
            for (file in files) {
                if (!file.endsWith(".dsx")) {
                    throw new Exception("[Error] '${file}' does not end with .dsx. All files must end with this extension.")
                }
            }
        }
        else {
            println "No files were given for DSX extension check."
        }
    }

    // Confirm each file ends with .isx
    public void checkISXExtensions(String ... isxs) {
        if (isxs) {
            def failFiles = []
            for (isx in isxs) {
                if (!isx.endsWith(".isx")) {
                    println "[Error] File '${isx}' does not end with .isx. All files must end with this extension."
                    failFiles << isx
                    continue
                }
                File file = new File(isx)
                if (!file.isFile()){
                    println "[Error] '${file}' was not found. Please enter a valid pathname."
                    failFiles << isx
                    continue
                }
            }
            if (failFiles.size() > 0){
                throw new FileNotFoundException("[Error] The following files are invalid: ${failFiles}")
            }
        }
        else {
            println "No files were given for ISX extension check."
        }
    }

    // Closure to get the output from the dscmds
    def systemOutput = ""
    public def getSystemOutput = {Process proc ->
        def out = new PrintStream(System.out, true)
        def outputStream = new StringBuilder()
        try {
            proc.waitForProcessOutput(outputStream, out)
        }
        finally {
            out.flush();
        }
        systemOutput = outputStream.toString()
    }
}
