/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web;

import com.urbancode.commons.web.util.ListeningInfo;
import com.urbancode.commons.web.util.WebAppContainerUtil;
import java.net.URI;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class UIAddressDisplayListener
implements ServletContextListener {
    private static final long serialVersionUID = -3833888890227106115L;
    private static final Logger log = Logger.getLogger(UIAddressDisplayListener.class);
    public static final String WEB_APP_NAME_INIT_PARAM = "webAppName";
    private String webAppName = "Web User Interface";

    public void contextInitialized(ServletContextEvent contextEvent) {
        try {
            ServletContext context = contextEvent.getServletContext();
            String contextName = context.getServletContextName();
            String webAppNameInitParam = context.getInitParameter(WEB_APP_NAME_INIT_PARAM);
            if (StringUtils.isNotEmpty((String)webAppNameInitParam)) {
                this.webAppName = webAppNameInitParam;
            } else if (StringUtils.isNotEmpty((String)contextName)) {
                this.webAppName = contextName;
            }
            System.out.println();
            System.out.println("*****************************************");
            System.out.println(" Started " + this.webAppName);
            WebAppContainerUtil util = new WebAppContainerUtil();
            Set<ListeningInfo> listeningInfos = util.getListeningInfo(context);
            for (ListeningInfo info : listeningInfos) {
                URI uri = info.getUri();
                System.out.print(" listening on ");
                System.out.print(uri);
                System.out.print(" (");
                System.out.print(uri.getScheme());
                if (StringUtils.isNotEmpty((String)info.getSslProtocol())) {
                    System.out.print(" - ");
                    System.out.print(info.getSslProtocol());
                }
                if (info.isAllAddresses()) {
                    System.out.print(", all addresses");
                }
                System.out.println(")");
            }
            if (listeningInfos.isEmpty()) {
                System.out.println(" could not determine listening urls");
            }
            System.out.println("*****************************************");
            System.out.println();
            System.out.flush();
        }
        catch (Exception e) {
            log.error(e, e);
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        System.out.println();
        System.out.println("*****************************************");
        System.out.println(" Stopped " + this.webAppName);
        System.out.println("*****************************************");
        System.out.println();
    }
}

