/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class RequestHelper {
    protected static String USER_AGENT_HEADER = "User-Agent";
    protected static String REQUESTED_WITH_HEADER = "X-Requested-With";

    public String getUserAgent(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getHeader(USER_AGENT_HEADER);
    }

    public boolean isBrowserUserAgent(HttpServletRequest httpServletRequest) {
        return this.isBrowserUserAgent(this.getUserAgent(httpServletRequest));
    }

    public boolean isBrowserUserAgent(String userAgent) {
        String[] browserUserAgentKeys;
        boolean isKnownBrowser = false;
        for (String browserKeywords : browserUserAgentKeys = new String[]{"Mozilla", "Opera"}) {
            if (!StringUtils.containsIgnoreCase(userAgent, browserKeywords)) continue;
            isKnownBrowser = true;
            break;
        }
        return isKnownBrowser;
    }

    public boolean isToolUserAgent(HttpServletRequest httpServletRequest) {
        return this.isToolUserAgent(this.getUserAgent(httpServletRequest));
    }

    public boolean isToolUserAgent(String userAgent) {
        boolean isKnownBrowser = this.isBrowserUserAgent(userAgent);
        return !isKnownBrowser;
    }

    public boolean isAjaxRequest(HttpServletRequest httpServletRequest) {
        String xRequestedWith = httpServletRequest.getHeader(REQUESTED_WITH_HEADER);
        boolean isAjax = StringUtils.containsIgnoreCase(xRequestedWith, "XMLHttpRequest");
        return isAjax;
    }
}

