/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class Bits {
    public static int clear(AtomicInteger value, int bits) {
        int update;
        int current;
        while (!value.compareAndSet(current = value.get(), update = Bits.clear(current, bits))) {
        }
        return update;
    }

    public static long clear(AtomicLong value, long bits) {
        long update;
        long current;
        while (!value.compareAndSet(current = value.get(), update = Bits.clear(current, bits))) {
        }
        return update;
    }

    public static int clear(int value, int bits) {
        return value & ~bits;
    }

    public static long clear(long value, long bits) {
        return value & (bits ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int invert(AtomicInteger value, int bits) {
        int update;
        int current;
        while (!value.compareAndSet(current = value.get(), update = Bits.invert(current, bits))) {
        }
        return update;
    }

    public static long invert(AtomicLong value, long bits) {
        long update;
        long current;
        while (!value.compareAndSet(current = value.get(), update = Bits.invert(current, bits))) {
        }
        return update;
    }

    public static int invert(int value, int bits) {
        return value ^ bits;
    }

    public static long invert(long value, long bits) {
        return value ^ bits;
    }

    public static boolean isAnySet(AtomicInteger value, int bits) {
        return (value.get() & bits) != 0;
    }

    public static boolean isAnySet(AtomicLong value, long bits) {
        return (value.get() & bits) != 0L;
    }

    public static boolean isAnySet(int value, int bits) {
        return (value & bits) != 0;
    }

    public static boolean isAnySet(long value, long bits) {
        return (value & bits) != 0L;
    }

    public static boolean isSet(AtomicInteger value, int bits) {
        return (value.get() & bits) == bits;
    }

    public static boolean isSet(AtomicLong value, long bits) {
        return (value.get() & bits) == bits;
    }

    public static boolean isSet(int value, int bits) {
        return (value & bits) == bits;
    }

    public static boolean isSet(long value, long bits) {
        return (value & bits) == bits;
    }

    public static int set(AtomicInteger value, int bits) {
        int update;
        int current;
        while (!value.compareAndSet(current = value.get(), update = Bits.set(current, bits))) {
        }
        return update;
    }

    public static int set(AtomicInteger value, int bits, boolean b) {
        return b ? Bits.set(value, bits) : Bits.clear(value, bits);
    }

    public static long set(AtomicLong value, long bits) {
        long update;
        long current;
        while (!value.compareAndSet(current = value.get(), update = Bits.set(current, bits))) {
        }
        return update;
    }

    public static int set(int value, int bits) {
        return value | bits;
    }

    public static int set(int value, int bits, boolean b) {
        return b ? Bits.set(value, bits) : Bits.clear(value, bits);
    }

    public static long set(long value, long bits) {
        return value | bits;
    }

    public static long set(long value, long bits, boolean b) {
        return b ? Bits.set(value, bits) : Bits.clear(value, bits);
    }

    private Bits() {
        throw new UnsupportedOperationException();
    }
}

