/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.docker

import java.util.regex.Matcher
import java.util.regex.Pattern

public class DockerUtils {

    public static def getEnvReferences(String input) {
        def result = [] as Set
        if (input != null && input.trim().length() > 0) {
            Pattern pattern = Pattern.compile('\\$\\{[^}]*}')
            Matcher matcher = pattern.matcher(input)

            while (matcher.find()) {
                String key = input.substring(matcher.start() + 2, matcher.end() - 1)
                result << key
            }
        }
        return result
    }

    public static def parseImageSpec(String rawImageSpec) {
        def result = new Expando()

        // qualified domain         registry.tld/org/namespace/image:1.0
        // -------- or --------     registry.tld/org/namespace/image
        // simple host and port     localhost:5000/namespace/image:1.0
        // -------- or --------     localhost:5000/namespace/image
        // implicit library         registry.tld/namespace/image:1.0
        // ------   or --------     registry.tld/namespace/image
        // no/implicit registry     namespace/image:1.0
        // ------   or --------     namesapce/image
        // implicit local library   image:1.0
        // ------   or --------     image
        // colon in repo spec       my:image:1.0
        // ------   or --------     my:image
        // Repo is everything before first slash, unless spec contains no dots and no colon before first slash.
        // If registry spec exists, remove it and trailing slash - called Repository Spec
        def registryImageArray = rawImageSpec.split("/", 2)

        //Break this string into a repo+tag and registry
        def repoAndTag
        def registrySpec
        def firstPart = registryImageArray[0]
        if (registryImageArray.length == 1 ) {
            //No slash - implicit registrySpec
            repoAndTag = firstPart
        }
        else if ( firstPart.contains(".") || firstPart.contains(":") ) {
            registrySpec = firstPart
            repoAndTag = registryImageArray[1]
        }
        else {
            repoAndTag = rawImageSpec
        }

        def imageSpec
        def versionSpec

        if (repoAndTag.contains(":")) {
            //is explicit version/tag
            def imageRefParts = repoAndTag.split(":")
            imageSpec = imageRefParts[0]
            versionSpec = imageRefParts[1]

        }
        else {
            //is implicit version
            imageSpec = repoAndTag
        }

        result.registry = registrySpec
        result.image = imageSpec
        result.version = versionSpec

        return result
    }

    public static String buildImageSpec (String registry, String imageName, String tag) {
        if (imageName) {
            def result = ""
            if (registry) {
                result = "$registry/"
            }

            result += imageName

            if (tag) {
                result += ":" + tag
            }

            return result.toString()
        }
    }

}
