/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ssl.SSLSocketConfig;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

@BridgeMethodsAdded
public class SSLParametersSocketConfig
implements SSLSocketConfig {
    private String[] cipherSuites;
    private String[] protocols;

    public SSLParametersSocketConfig(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = this.clone(cipherSuites);
    }

    public String[] getCipherSuites() {
        return this.clone(this.cipherSuites);
    }

    public void setProtocols(String[] protocols) {
        this.protocols = this.clone(protocols);
    }

    public String[] getProtocols() {
        return this.clone(this.protocols);
    }

    private String[] clone(String[] s) {
        return s == null ? null : (String[])s.clone();
    }

    public void configure(SSLSocket socket) {
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null && this.protocols.length > 0) {
            socket.setEnabledProtocols(this.protocols);
        }
    }

    public void configure(SSLServerSocket socket) {
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.protocols != null && this.protocols.length > 0) {
            socket.setEnabledProtocols(this.protocols);
        }
    }
}

