/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.docker.DockerHelper

def apTool = new AirPluginTool(this.args[0], this.args[1])
def command = this.args[2]
def props = apTool.getStepProperties()
def helper = new DockerHelper(apTool)

/* Run the 'swarm init' command */
helper.runDockerCommand(command, props)

/* Get the worker and manager tokens as well as the manager host:port and make them available as output properties */
props["swarmTokenType"] = "worker"
apTool.setOutputProperty("swarmWorkerToken", helper.getSwarmToken(props))
apTool.setOutputProperty("swarmManagerAddress", helper.getSwarmManagerAddr())
props["swarmTokenType"] = "manager"
apTool.setOutputProperty("swarmManagerToken", helper.getSwarmToken(props))
apTool.storeOutputProperties()
