/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import java.io.File;

public class JdkUtil {
    private static JdkUtil jdkUtil = null;
    private String javaHome = System.getProperty("java.home");

    public static JdkUtil getInstance() {
        if (jdkUtil == null) {
            jdkUtil = new JdkUtil();
        }
        return jdkUtil;
    }

    private JdkUtil() {
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJdkExecutable(String command) {
        File executable = JdkUtil.findInDir(this.javaHome + "/../bin", command);
        if (executable != null) {
            return executable.getAbsolutePath();
        }
        return this.getJreExecutable(command);
    }

    public String getJreExecutable(String command) {
        File executable = JdkUtil.findInDir(this.javaHome + "/bin", command);
        if (executable != null) {
            return executable.getAbsolutePath();
        }
        return JdkUtil.addExtension(command);
    }

    private static File findInDir(String dirName, String commandName) {
        File dir = new File(dirName);
        File executable = null;
        if (dir.exists() && !(executable = new File(dir, JdkUtil.addExtension(commandName))).exists()) {
            executable = null;
        }
        return executable;
    }

    private static String addExtension(String command) {
        return command + (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0 ? ".exe" : "");
    }
}

