/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* UrbanCode Build
* UrbanCode Release
* AnthillPro
* (c) Copyright IBM Corporation 2011, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]) 
def props = apTool.getStepProperties();

def duration = props["duration"]
println "Waiting for ${duration} seconds."
try {
    def durationMillis = Long.parseLong(duration)*1000
    sleep(durationMillis)
    println "Finished waiting ${duration} seconds."
}
catch (NumberFormatException e) {
    println "Error: ${duration} is not a valid number. Exiting the step."
    System.exit(1)
}
