/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.filelister;

import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import java.io.File;
import java.util.Collections;

class SymlinkFile
extends TypedFile {
    private final String linkPath;

    SymlinkFile(String path, String linkPath) {
        super(path, Collections.emptySet());
        if (linkPath == null) {
            throw new NullPointerException("linkPath");
        }
        linkPath = linkPath.replace('\\', '/');
        this.linkPath = linkPath = linkPath.replace(File.separatorChar, '/');
    }

    public String linkPath() {
        return this.linkPath;
    }

    public FileType type() {
        return FileType.SYMLINK;
    }

    public String toString() {
        return super.toString() + " -> " + this.linkPath();
    }
}

