/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.IntegrationClient;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.stream.Collectors;

public class DownloadStep {
    final Properties input;
    final Properties output;

    public DownloadStep(Properties input, Properties output) {
        this.input = input;
        this.input.getClass();
        this.output = output;
        this.output.getClass();
    }

    public int execute() throws Exception {
        try (IntegrationClient client = this.getClient();){
            String version = this.input.getProperty("version").trim();
            IntegrationClient.PackageVersion ver = client.getVersion(version);
            client.downloadFiles(new File("."), ver, this.getIncludes(), this.getExcludes());
            int n = 0;
            return n;
        }
    }

    private IntegrationClient getClient() {
        String serverUrl = this.input.getProperty("serverUrl");
        String accessToken = this.input.getProperty("accessToken");
        String projectId = this.input.getProperty("projectId");
        String packageName = this.input.getProperty("packageName");
        String status = this.input.getProperty("status");
        return new IntegrationClient(serverUrl.trim(), accessToken.trim(), projectId.trim(), packageName.trim(), status);
    }

    private Collection<String> getIncludes() {
        return this.getStringArray(this.input.getProperty("includes"), Collections.singleton("**/*"));
    }

    private Collection<String> getExcludes() {
        return this.getStringArray(this.input.getProperty("excludes"), Collections.emptySet());
    }

    private Collection<String> getStringArray(String str, Collection<String> def) {
        if (str == null || str.trim().length() < 1) {
            return def;
        }
        return Arrays.stream(str.trim().split(",|\n")).map(String::trim).collect(Collectors.toSet());
    }
}

