/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class DisableSessionUrlFilter
implements Filter {
    private static final Logger log = Logger.getLogger(DisableSessionUrlFilter.class);

    public void init(FilterConfig arg0) {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpSession session;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        boolean isUrlSession = httpRequest.isRequestedSessionIdFromURL();
        if (isUrlSession && (session = httpRequest.getSession(false)) != null) {
            session.invalidate();
        }
        if (DSUHttpServletReponseWapper.isWrapped((ServletResponse)httpResponse)) {
            chain.doFilter(request, (ServletResponse)httpResponse);
        } else {
            chain.doFilter(request, (ServletResponse)new DSUHttpServletReponseWapper(httpResponse));
        }
    }

    public void destroy() {
    }

    private static class DSUHttpServletReponseWapper
    extends HttpServletResponseWrapper {
        public static boolean isWrapped(ServletResponse response) {
            if (DSUHttpServletReponseWapper.class.isInstance(response)) {
                return true;
            }
            if (DSUHttpServletReponseWapper.class.isInstance(response)) {
                HttpServletResponseWrapper wrapperRequest = (HttpServletResponseWrapper)response;
                return DSUHttpServletReponseWapper.isWrapped(wrapperRequest.getResponse());
            }
            return false;
        }

        public DSUHttpServletReponseWapper(HttpServletResponse arg0) {
            super(arg0);
        }

        public String encodeRedirectUrl(String url) {
            return url;
        }

        public String encodeRedirectURL(String url) {
            return url;
        }

        public String encodeUrl(String url) {
            return url;
        }

        public String encodeURL(String url) {
            return url;
        }
    }
}

