/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import com.urbancode.commons.util.FilePatternFileFilter;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.Paths;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.StatusLine;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class IntegrationClient
implements AutoCloseable {
    private String serverUrl;
    private String authHeader;
    private String status;
    private String projectId;
    private String packageName;
    private CloseableHttpClient client;
    private Logger logger = Logger.getLogger(this.getClass());

    IntegrationClient(String serverUrl, String accessToken, String projectId, String packageName, String status) {
        this(serverUrl, accessToken, projectId, packageName, status, null);
    }

    IntegrationClient(String serverUrl, String accessToken, String projectId, String packageName, String status, CloseableHttpClient client) {
        while (serverUrl.endsWith("/")) {
            serverUrl = serverUrl.substring(0, serverUrl.length() - 1);
        }
        this.serverUrl = serverUrl;
        this.client = this.createHttpClient();
        this.status = status;
        this.projectId = projectId;
        this.authHeader = "Bearer " + accessToken;
        this.packageName = packageName;
        this.client = client != null ? client : this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setTimeoutMillis(60000);
        CloseableHttpClient result = builder.buildClient();
        return result;
    }

    public List<PackageVersion> getVersionList() throws IOException, ParseException, JSONException {
        return this.getVersionList(null);
    }

    public List<PackageVersion> getVersionList(String versionName) throws IOException, ParseException, JSONException {
        boolean specificVersion = StringUtils.isNotEmpty((CharSequence)versionName);
        StringBuilder url = new StringBuilder().append(this.serverUrl).append("/api/v4/projects/").append(this.projectId).append("/packages?").append("package_type=generic").append("&sort=desc").append("&order_by=created_at");
        if (StringUtils.isNotEmpty((CharSequence)this.status)) {
            url.append("&status=").append(this.encode(this.status));
        }
        if (StringUtils.isNotEmpty((CharSequence)this.packageName)) {
            url.append("&package_name=").append(this.encode(this.packageName));
        }
        String curUrl = url.toString();
        ArrayList<PackageVersion> result = new ArrayList<PackageVersion>();
        this.get(curUrl, resp -> {
            try {
                JSONArray arr = new JSONArray(EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)Charset.forName("UTF-8")));
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    if (specificVersion && this.packageName.equals(obj.getString("name")) && versionName.equals(obj.getString("version"))) {
                        result.add(new PackageVersion(obj.getString("version"), obj.getString("id")));
                        return true;
                    }
                    if (specificVersion || !this.packageName.equals(obj.getString("name"))) continue;
                    result.add(new PackageVersion(obj.getString("version"), obj.getString("id")));
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return result;
    }

    private void get(String startUrl, Function<CloseableHttpResponse, Boolean> handler) throws IOException {
        String curUrl = startUrl;
        while (StringUtils.isNotEmpty((CharSequence)curUrl)) {
            HttpGet get = new HttpGet(curUrl);
            get.addHeader("Authorization", this.authHeader);
            CloseableHttpResponse resp = this.client.execute((HttpUriRequest)get);
            Throwable throwable = null;
            try {
                StatusLine sl = resp.getStatusLine();
                int code = sl.getStatusCode();
                if (code < 200 || code > 299) {
                    throw new IOException("Error getting version list: " + code + " " + sl.getReasonPhrase());
                }
                if (handler.apply(resp).booleanValue()) break;
                curUrl = this.getNextUrl(resp.getFirstHeader("Link").getValue());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (resp == null) continue;
                if (throwable != null) {
                    try {
                        resp.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                resp.close();
            }
        }
    }

    public boolean containsVersion(String version) throws IOException, ParseException, JSONException {
        return this.getVersionList(version).size() > 0;
    }

    public PackageVersion getVersion(String version) throws IOException, ParseException, JSONException {
        List<PackageVersion> list = this.getVersionList(version);
        if (list.size() < 1) {
            throw new IllegalArgumentException(String.format("Version with name \"%s\" not found.", version));
        }
        return list.get(0);
    }

    private String getNextUrl(String header) {
        if (StringUtils.isEmpty((CharSequence)header)) {
            return null;
        }
        String[] links = header.split(",");
        return Arrays.stream(links).filter(it -> "next".equals(this.getRel((String)it))).findFirst().map(this::getUrl).orElse(null);
    }

    private String getRel(String link) {
        if (StringUtils.isEmpty((CharSequence)link)) {
            return null;
        }
        String[] params = link.split(";");
        return Arrays.stream(params).skip(1L).map(it -> it.split("=", 2)).collect(Collectors.toMap(it -> it[0].trim(), it -> this.trimQuotes(it[1]).trim())).get("rel");
    }

    private String getUrl(String link) {
        String url = link.split(";")[0];
        url = url.substring(1, url.length() - 1).trim();
        return url;
    }

    private String trimQuotes(String str) {
        while (str.startsWith("\"")) {
            str = str.substring(1);
        }
        while (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Platform must support UTF-8");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.client != null) {
            this.client.close();
        }
    }

    public void downloadFiles(File directory, PackageVersion version, Collection<String> includes, Collection<String> excludes) throws IOException, JSONException {
        List<String> resources = this.getFileListForVersion(version, includes, excludes);
        Predicate<String> safe = Paths::isPathSafe;
        String unsafePaths = resources.stream().filter(safe.negate()).collect(Collectors.joining(","));
        if (unsafePaths.length() > 0) {
            StringBuilder mes = new StringBuilder();
            mes.append("Found files with unsafe paths: ").append(unsafePaths);
            throw new IOException(mes.toString());
        }
        this.logger.info((Object)("Downloading files in version: " + version.getName() + "..."));
        for (String file : resources) {
            this.download(directory, version, file);
        }
    }

    private void download(File directory, PackageVersion version, String filename) throws IOException {
        String url = this.serverUrl + "/api/v4/projects/" + this.projectId + "/packages/generic/" + this.packageName + "/" + version.getName() + "/" + filename;
        HttpGet get = new HttpGet(url);
        get.addHeader("Authorization", this.authHeader);
        try (CloseableHttpResponse resp = this.client.execute((HttpUriRequest)get);){
            StatusLine sl = resp.getStatusLine();
            int code = sl.getStatusCode();
            if (code < 200 || code > 299) {
                throw new IOException("Error getting file \"" + url + "\": " + code + " " + sl.getReasonPhrase());
            }
            File file = new File(directory, filename);
            IO.copy(resp.getEntity().getContent(), file);
        }
    }

    private List<String> getFileListForVersion(PackageVersion version, Collection<String> includes, Collection<String> excludes) throws IOException, JSONException {
        File workDir = new File(".");
        FilePatternFileFilter filt = new FilePatternFileFilter(workDir, includes, excludes);
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder url = new StringBuilder().append(this.serverUrl).append("/api/v4/projects/").append(this.projectId).append("/packages/").append(version.getId()).append("/package_files");
        this.get(url.toString(), resp -> {
            try {
                JSONArray res = new JSONArray(EntityUtils.toString((HttpEntity)resp.getEntity(), (Charset)Charset.forName("UTF-8")));
                for (int i = 0; i < res.length(); ++i) {
                    String filename = res.getJSONObject(i).getString("file_name");
                    File f = new File(workDir, filename);
                    if (!filt.accept(f)) continue;
                    result.add(filename);
                }
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        return result;
    }

    class PackageVersion {
        String name;
        String id;

        private PackageVersion(String name, String id) {
            this.name = name;
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public String getId() {
            return this.id;
        }
    }
}

