/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.IntegrationClient;
import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.Paths;
import com.urbancode.commons.util.UnsafePathException;
import com.urbancode.ud.client.ComponentClient;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ImportVersion {
    private Properties inputProperties;
    private Properties outputProperties;
    private Logger logger;

    public ImportVersion(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
        this.logger = Logger.getLogger(this.getClass());
        String logLevel = inputProperties.getProperty("loggerLevel");
        Logger.getRootLogger().setLevel(Level.toLevel((String)logLevel));
    }

    private IntegrationClient createClient() {
        String serverUrl = this.inputProperties.getProperty("serverUrl");
        String accessToken = this.inputProperties.getProperty("accessToken");
        String projectId = this.inputProperties.getProperty("projectId");
        String packageName = this.inputProperties.getProperty("packageName");
        String status = this.inputProperties.getProperty("status");
        return new IntegrationClient(serverUrl.trim(), accessToken.trim(), projectId.trim(), packageName.trim(), status);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int execute() throws IOException {
        int result = 0;
        try (IntegrationClient integrationClient = this.createClient();){
            Properties agentProps = new Properties();
            agentProps.load(new FileInputStream(new File(System.getenv("AGENT_HOME"), "conf/agent/installed.properties")));
            String revision = this.inputProperties.getProperty("version");
            String charsetName = agentProps.getProperty("system.default.encoding");
            String componentName = this.inputProperties.getProperty("componentName");
            boolean isUseVFS = Boolean.valueOf(this.inputProperties.getProperty("isUseVFS"));
            boolean unzipArchive = Boolean.valueOf(this.inputProperties.getProperty("unzipArchive"));
            boolean checkHash = Boolean.valueOf(this.inputProperties.getProperty("checkHash"));
            String versionPattern = this.inputProperties.getProperty("versionPattern");
            String[] includes = this.getIncludes();
            String[] excludes = this.getExcludes();
            String[] extensions = this.getExtensions();
            Charset charset = null;
            if (charsetName != null) {
                charset = Charset.forName(charsetName);
            }
            String ucdUser = "PasswordIsAuthToken";
            String ucdPass = String.format("{\"token\": \"%s\"}", System.getenv("AUTH_TOKEN"));
            String webUrl = System.getenv("AH_WEB_URL");
            URI ucdUrl = new URI(webUrl);
            VersionClient versionClient = new VersionClient(ucdUrl, ucdUser, ucdPass);
            ComponentClient componentClient = new ComponentClient(ucdUrl, ucdUser, ucdPass);
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{revision})) {
                if (!integrationClient.containsVersion(revision) || versionClient.getVersionId(componentName, revision) != null) throw new IllegalArgumentException(String.format("Version with name \"%s\" not found.", revision));
                this.integrate(integrationClient, componentClient, versionClient, componentName, integrationClient.getVersion(revision), isUseVFS, unzipArchive, checkHash, charset, extensions, includes, excludes);
                return result;
            } else {
                List<IntegrationClient.PackageVersion> versions = integrationClient.getVersionList();
                List existingVersions = componentClient.getComponentVersions(componentName, Boolean.valueOf(false));
                List archivedVersions = componentClient.getArchivedComponentVersions(componentName);
                existingVersions.addAll(archivedVersions);
                Pattern pattern = versionPattern != null && !versionPattern.isEmpty() ? Pattern.compile(versionPattern) : Pattern.compile(".*");
                versions = versions.stream().filter(it -> !existingVersions.contains(it.getName())).filter(version -> pattern.matcher(version.name.toString()).matches()).collect(Collectors.toList());
                int importCount = 0;
                for (IntegrationClient.PackageVersion version2 : versions) {
                    if (!this.integrate(integrationClient, componentClient, versionClient, componentName, version2, isUseVFS, unzipArchive, checkHash, charset, extensions, includes, excludes)) continue;
                    ++importCount;
                }
                if (versions.size() < 1) {
                    this.logger.info((Object)"Did not find any versions to import.");
                    return result;
                } else {
                    if (importCount != 0) return result;
                    this.logger.info((Object)"This component already contains all versions.");
                }
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error((Object)String.format("Error Creating New Version: %s", e.getMessage()), (Throwable)e);
            return 1;
        }
    }

    private String[] getExtensions() {
        String extensionString = this.inputProperties.getProperty("extensions");
        String[] extensions = new String[]{};
        if (extensionString != null) {
            extensions = extensionString.split(",");
            for (int i = 0; i < extensions.length; ++i) {
                extensions[i] = extensions[i].trim();
            }
        }
        return extensions;
    }

    private String[] getExcludes() {
        String excludesString = this.inputProperties.getProperty("excludes");
        String[] excludes = new String[]{};
        if (excludesString != null) {
            excludes = excludesString.split(",|\n");
            for (int i = 0; i < excludes.length; ++i) {
                excludes[i] = excludes[i].trim();
            }
        }
        return excludes;
    }

    private String[] getIncludes() {
        String includesString = this.inputProperties.getProperty("includes");
        String[] includes = new String[]{};
        if (includesString != null) {
            if (includesString.trim().length() == 0) {
                includesString = "**/*";
            }
            includes = includesString.split(",|\n");
            for (int i = 0; i < includes.length; ++i) {
                includes[i] = includes[i].trim();
            }
        }
        return includes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean integrate(IntegrationClient integrationClient, ComponentClient componentClient, VersionClient versionClient, String componentName, IntegrationClient.PackageVersion version, boolean isUseVFS, boolean unzipArchive, boolean checkHash, Charset charset, String[] extensions, String[] includes, String[] excludes) throws Exception {
        File tempDir = null;
        boolean result = false;
        try {
            boolean saveExecuteBits = Boolean.valueOf(this.inputProperties.getProperty("saveFileExecuteBits"));
            if (isUseVFS) {
                this.logger.info((Object)("Creating new version: " + version.getName() + " and uploading files to VFS"));
                tempDir = new File(UUID.randomUUID().toString());
                tempDir.mkdirs();
                integrationClient.downloadFiles(tempDir, version, Arrays.asList(includes), Arrays.asList(excludes), checkHash);
                if (unzipArchive) {
                    this.unzipRecursive(tempDir);
                }
                UUID versionId = versionClient.createAndAddVersionFiles(componentName, version.getName(), "", tempDir, "", includes, excludes, saveExecuteBits, true, charset, extensions);
                this.outputProperties.setProperty("VersionID", versionId.toString());
            } else {
                this.logger.info((Object)("Creating new version: " + version.getName()));
                String versionId = versionClient.createVersion(componentName, version.getName(), " ").toString();
                this.outputProperties.setProperty("VersionID", versionId);
            }
            result = true;
        }
        catch (Throwable throwable) {
            try {
                if (tempDir != null && tempDir.exists()) {
                    IO.delete(tempDir);
                }
            }
            catch (IOException e) {
                this.logger.error((Object)String.format("Unable to delete download directory", e.getMessage()));
            }
            throw throwable;
        }
        try {
            if (tempDir != null && tempDir.exists()) {
                IO.delete(tempDir);
            }
        }
        catch (IOException e) {
            this.logger.error((Object)String.format("Unable to delete download directory", e.getMessage()));
        }
        return result;
    }

    public void unzipRecursive(File directory) throws IOException {
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.unzipRecursive(file);
                    continue;
                }
                if (!file.getName().endsWith(".zip") && !file.getName().endsWith(".jar")) continue;
                try {
                    String folderName = file.getName().substring(0, file.getName().lastIndexOf(46));
                    File destDir = new File(directory, folderName);
                    boolean unzipped = this.unzipFile(file, destDir);
                    if (!unzipped) continue;
                    System.out.println("[Info] File: '" + file.getName() + "' unzipped, deleting archive...");
                    file.delete();
                }
                catch (IOException e) {
                    throw new IOException("[Error] Failed to unzip file: " + e.getMessage());
                }
            }
        }
    }

    public boolean unzipFile(File zipFile, File outputFolder) throws IOException {
        boolean unzipped = false;
        try (ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));){
            ZipEntry zipEntry = null;
            if (!outputFolder.exists()) {
                outputFolder.mkdir();
            }
            while ((zipEntry = zis.getNextEntry()) != null) {
                unzipped = true;
                String entryName = zipEntry.getName();
                File newFile = new File(outputFolder, entryName);
                if (!Paths.isPathSafe(zipEntry.getName())) {
                    throw new UnsafePathException("Unsafe path: " + zipEntry.getName());
                }
                if (zipEntry.isDirectory()) {
                    newFile.mkdirs();
                } else {
                    IO.copy((InputStream)zis, newFile);
                }
                zipEntry = zis.getNextEntry();
            }
            zis.closeEntry();
            boolean bl = unzipped;
            return bl;
        }
    }
}

