/*
 * Licensed Materials - Property of HCL
 * UrbanCode Deploy
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.loadrunner.LRCLIHelper

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
Properties props = apTool.getStepProperties()

String lrInstallDir = props['lrInstallDir'].trim()
String testPath = props['testPath'].trim()
String templateName = props['templateName'].trim()
String lrResultsName = props['lrResultsName'].trim()
File workDir = new File('.').canonicalFile

LRCLIHelper wlHelper = new LRCLIHelper(lrInstallDir, workDir)
int exitVal = wlHelper.runTestScenario(testPath, lrResultsName)
exitVal = wlHelper.runTestAnalysis(templateName, lrResultsName)

System.exit(exitVal)