/**
 * (c) Copyright IBM Corporation 2013, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool;

import com.urbancode.air.plugin.ibmace.ACERestClient

File workDir = new File('.');

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties(System.getenv("UCD_SECRET_VAR"))

def helper = new ACERestClient(props)

String integrationServerName = props['integrationServerName']
def integrationServerNames
if(integrationServerName != null && !integrationServerName.trim().isEmpty()) {
    integrationServerNames = integrationServerName.split('\n|,')*.trim()
    integrationServerNames -= [null, ""] // remove empty and null entries
}

try {
    if (integrationServerNames) {
        println("${helper.getTimestamp()} Creating integration servers: ${integrationServerNames}...")
    }
    else {
        throw new IllegalStateException("No integration servers names to create.")
    }

    for (String serverName : integrationServerNames) {
        helper.createIntegrationServer(serverName);
    }
}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}
finally {
    helper.cleanUp()
}
