/**
 * (c) Copyright IBM Corporation 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.plugin.ibmace.ACERestClient;

File workDir = new File('.');

AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties(System.getenv("UCD_SECRET_VAR"))

def helper = new ACERestClient(props)

String integrationServer = props['integrationServer'].trim()

boolean exists = false
try {
    System.out.println("[Action] Identifying Integration Server: " + integrationServer)
    exists = helper.doesIntegrationServerExist(integrationServer)
    if (exists) {
        System.out.println("[Info] Integration Server found.")
    } else {
        System.out.println("[Info] Integration Server not found.")
    }
}
catch (Exception e) {
    e.printStackTrace()
    throw e
}
finally {
    apTool.setOutputProperty("exists", exists.toString())
    apTool.setOutputProperties(System.getenv("UCD_SECRET_VAR"))
    helper.cleanUp()
}

if (!exists) {
    System.exit(1)
}
