/**
 * (c) Copyright IBM Corporation 2016, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */

package com.urbancode.air.plugin.ibmace;

public class ACEConstants {

    private static String pathSeperator = "/"

    final private static  String API_VERSION = "/apiv2"

    // Common actions on server, components, applications, rest apis
    final private static String DELETE = "/delete"
    final private static String DELETE_ALL = "/delete-all"
    final private static String DEPLOY = "/deploy"
    final private static String RESET_SERVICE_TRACE = "/reset-service-trace"
    final private static String RESET_USER_TRACE  = "/reset-user-trace"
    final private static String SETUP  = "/setup"
    final private static String SHUTDOWN  = "/shutdown"
    final private static String START  = "/start"
    final private static String RESTART  = "/restart"
    final private static String START_SERVICE_TRACE  = "/start-service-trace"
    final private static String START_USER_TRACE  = "/start-user-trace"
    final private static String STOP  = "/stop"
    final private static String STOP_SERVICE_TRACE  = "/stop-service-trace"
    final private static String STOP_USER_TRACE  = "/stop-user-trace"
    final private static String TEARDOWN  = "/teardown"
    final private static String VALIDATE  = "/validate"
    final private static String COMPONENTS = "/components"
    final private static String SERVERS = "/servers"

    // Server apis
    final private static String GET_SERVERS = API_VERSION + SERVERS
    final private static String CREATE_SERVER = GET_SERVERS

    // get server path by name or id
    public static String getServerPathByNameOrId(String serverNameOrId) {
        return GET_SERVERS + pathSeperator + serverNameOrId
    }

    // get server path by name or id with action
    public static String getServerActionPathByNameOrId(String serverNameOrId, String action) {
        return getServerPathByNameOrId(serverNameOrId) + action
    }

    //TODO other apis

}
