/**
 * (c) Copyright IBM Corporation 2013, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.ibmace.ACERestClient
import com.urbancode.air.plugin.ibmace.MQSIHelper



MQSIHelper mqHelper
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()
def installDir = props['installDir'].trim()
def integrationNode = props['integrationNode'].trim()
def polyName = props['servName'];
def polyType = props['servType'];
def propsString = props['props'];
def traceDir = props['debugFile'].trim()
def propertieskey = [];
def propertiesvalue = [];
propsString.split('\n').each {
    def parts = it.split('->|=', 2);
    if (parts.length != 2) {
        System.out.println("Found a property definition that doesn't match the expected syntax. Skipping.");
        System.out.println(it);
    }
    else {
		propertieskey.push(parts[0].trim());
		propertiesvalue.push(parts[1].trim());
    }
}

try {
	mqHelper = new MQSIHelper(installDir, apTool.isWindows)
}
catch(FileNotFoundException ex) {
	println("Unable to locate mqsi script directory:")
	println(ex.message)
}

try {
	if(propertieskey.size()>0){
		propertieskey = propertieskey.join(',');
		propertiesvalue = propertiesvalue.join(',');
	}
	mqHelper.CreatePolicy(integrationNode, polyName, polyType, propertieskey, propertiesvalue, traceDir)
}
catch(ExitCodeException ex) {
	println(ex.message)
	System.exit(1)
}
catch(FileNotFoundException ex) {
	println("Could not locate necessary mqsi script file:")
	println(ex.message)
	System.exit(1)
}