/**
 * (c) Copyright IBM Corporation 2013, 2017.
 * (c) Copyright HCL Technologies Ltd. 2018, 2019. All Rights Reserved.
 * This is licensed under the following license.
 * The Eclipse Public 1.0 License (http://www.eclipse.org/legal/epl-v10.html)
 * U.S. Government Users Restricted Rights:  Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 */
import com.urbancode.air.AirPluginTool;
import com.urbancode.air.ExitCodeException
import com.urbancode.air.plugin.ibmace.ACERestClient
import com.urbancode.air.plugin.ibmace.MQSIHelper



MQSIHelper mqHelper
AirPluginTool apTool = new AirPluginTool(this.args[0], this.args[1])
def props = apTool.getStepProperties()

def installDir = props['installDir']?.trim()
def integrationNodeName = props['integrationNodeName']?.trim()
def integrationNodeFileName = props['integrationNodeFileName']?.trim()
def ipAddress = props['ipAddress']?.trim()
def port = props['port']?.trim()
def BARFile = props['BARFile']?.trim()
def deployedObjects = props['deployedObjects']?.trim()
def integrationServerName = props['integrationServerName']?.trim()
def clear = props['clear']?.trim().toBoolean()
def traceFileName = props['traceFileName']?.trim()
def timeoutValue = props['timeoutValue']?.trim()

try {
	mqHelper = new MQSIHelper(installDir, apTool.isWindows)
}
catch(FileNotFoundException ex) {
	println("Unable to locate mqsi script directory:")
	println(ex.message)
}

try {
	mqHelper.deployBarFile(integrationNodeName, integrationNodeFileName, ipAddress, port, BARFile, deployedObjects, integrationServerName, clear, traceFileName, timeoutValue)

}
catch(ExitCodeException ex) {
	println("Could not deploy bar file:")
	println(ex.message)
	System.exit(1)
}
catch(FileNotFoundException ex) {
	println("Could not locate necessary mqsi script file:")
	println(ex.message)
	System.exit(1)
}
/*
def integrationServerNames
if(integrationServerName != null && !integrationServerName.trim().isEmpty()) {
    integrationServerNames = integrationServerName.split('\n|,')*.trim()
    integrationServerNames -= [null, ""] // remove empty and null entries
}


try {
	
    props['barFileNames'].split('\n|,')*.trim().each { barFileName ->
        println "${helper.getTimestamp()} Deploying bar file ${barFileName}";

        for (String serverName : integrationServerNames) {

            helper.deployBarFile(serverName, barFileName);

            println("${helper.getTimestamp()} ${barFileName} was successfully deployed to ${serverName}.")
            
        }
    }
    
	
}
catch (Exception e) {
    e.printStackTrace();
    throw e;
}
finally {
    apTool.setOutputProperties(System.getenv("UCD_SECRET_VAR"))
    helper.cleanUp();
}
*/