/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.core;

import org.springframework.ldap.BadLdapGrammarException;

public class LdapEncoder {
    private static String[] nameEscapeTable;
    private static String[] filterEscapeTable;

    private LdapEncoder() {
    }

    protected static String toTwoCharHex(char c) {
        String raw = Integer.toHexString(c).toUpperCase();
        if (raw.length() > 1) {
            return raw;
        }
        return "0" + raw;
    }

    public static String filterEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer encodedValue = new StringBuffer(value.length() * 2);
        int length = value.length();
        for (int i = 0; i < length; ++i) {
            char c = value.charAt(i);
            if (c < filterEscapeTable.length) {
                encodedValue.append(filterEscapeTable[c]);
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    public static String nameEncode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer encodedValue = new StringBuffer(value.length() * 2);
        int length = value.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            String esc;
            char c = value.charAt(i);
            if (c == ' ' && (i == 0 || i == last)) {
                encodedValue.append("\\ ");
                continue;
            }
            if (c < nameEscapeTable.length && (esc = nameEscapeTable[c]) != null) {
                encodedValue.append(esc);
                continue;
            }
            encodedValue.append(c);
        }
        return encodedValue.toString();
    }

    public static String nameDecode(String value) throws BadLdapGrammarException {
        if (value == null) {
            return null;
        }
        StringBuffer decoded = new StringBuffer(value.length());
        int i = 0;
        while (i < value.length()) {
            char currentChar = value.charAt(i);
            if (currentChar == '\\') {
                if (value.length() <= i + 1) {
                    throw new BadLdapGrammarException("Unexpected end of value unterminated '\\'");
                }
                char nextChar = value.charAt(i + 1);
                if (nextChar == ',' || nextChar == '=' || nextChar == '+' || nextChar == '<' || nextChar == '>' || nextChar == '#' || nextChar == ';' || nextChar == '\\' || nextChar == '\"' || nextChar == ' ') {
                    decoded.append(nextChar);
                    i += 2;
                    continue;
                }
                if (value.length() <= i + 2) {
                    throw new BadLdapGrammarException("Unexpected end of value expected special or hex, found '" + nextChar + "'");
                }
                String hexString = "" + nextChar + value.charAt(i + 2);
                decoded.append((char)Integer.parseInt(hexString, 16));
                i += 3;
                continue;
            }
            decoded.append(currentChar);
            ++i;
        }
        return decoded.toString();
    }

    static {
        char c;
        nameEscapeTable = new String[96];
        filterEscapeTable = new String[93];
        for (c = '\u0000'; c < ' '; c = (char)(c + '\u0001')) {
            LdapEncoder.nameEscapeTable[c] = "\\" + LdapEncoder.toTwoCharHex(c);
        }
        LdapEncoder.nameEscapeTable[35] = "\\#";
        LdapEncoder.nameEscapeTable[44] = "\\,";
        LdapEncoder.nameEscapeTable[59] = "\\;";
        LdapEncoder.nameEscapeTable[61] = "\\=";
        LdapEncoder.nameEscapeTable[43] = "\\+";
        LdapEncoder.nameEscapeTable[60] = "\\<";
        LdapEncoder.nameEscapeTable[62] = "\\>";
        LdapEncoder.nameEscapeTable[34] = "\\\"";
        LdapEncoder.nameEscapeTable[92] = "\\\\";
        for (c = '\u0000'; c < filterEscapeTable.length; c = (char)(c + '\u0001')) {
            LdapEncoder.filterEscapeTable[c] = String.valueOf(c);
        }
        LdapEncoder.filterEscapeTable[42] = "\\2a";
        LdapEncoder.filterEscapeTable[40] = "\\28";
        LdapEncoder.filterEscapeTable[41] = "\\29";
        LdapEncoder.filterEscapeTable[92] = "\\5c";
        LdapEncoder.filterEscapeTable[0] = "\\00";
    }
}

