/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.ldap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.config.authentication.PasswordEncoderParser;
import org.springframework.security.config.ldap.LdapUserServiceBeanDefinitionParser;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class LdapProviderBeanDefinitionParser
implements BeanDefinitionParser {
    private Log logger = LogFactory.getLog(this.getClass());
    private static final String ATT_USER_DN_PATTERN = "user-dn-pattern";
    private static final String ATT_USER_PASSWORD = "password-attribute";
    private static final String ATT_HASH = "hash";
    private static final String DEF_USER_SEARCH_FILTER = "uid={0}";
    static final String PROVIDER_CLASS = "org.springframework.security.ldap.authentication.LdapAuthenticationProvider";
    static final String BIND_AUTH_CLASS = "org.springframework.security.ldap.authentication.BindAuthenticator";
    static final String PASSWD_AUTH_CLASS = "org.springframework.security.ldap.authentication.PasswordComparisonAuthenticator";

    public BeanDefinition parse(Element elt, ParserContext parserContext) {
        RuntimeBeanReference contextSource = LdapUserServiceBeanDefinitionParser.parseServerReference(elt, parserContext);
        RootBeanDefinition searchBean = LdapUserServiceBeanDefinitionParser.parseSearchBean(elt, parserContext);
        String userDnPattern = elt.getAttribute(ATT_USER_DN_PATTERN);
        String[] userDnPatternArray = new String[]{};
        if (StringUtils.hasText((String)userDnPattern)) {
            userDnPatternArray = new String[]{userDnPattern};
        } else if (searchBean == null) {
            this.logger.info((Object)"No search information or DN pattern specified. Using default search filter 'uid={0}'");
            BeanDefinitionBuilder searchBeanBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)"org.springframework.security.ldap.search.FilterBasedLdapUserSearch");
            searchBeanBuilder.getRawBeanDefinition().setSource((Object)elt);
            searchBeanBuilder.addConstructorArgValue((Object)"");
            searchBeanBuilder.addConstructorArgValue((Object)DEF_USER_SEARCH_FILTER);
            searchBeanBuilder.addConstructorArgValue((Object)contextSource);
            searchBean = searchBeanBuilder.getBeanDefinition();
        }
        BeanDefinitionBuilder authenticatorBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)BIND_AUTH_CLASS);
        Element passwordCompareElt = DomUtils.getChildElementByTagName((Element)elt, (String)"password-compare");
        if (passwordCompareElt != null) {
            authenticatorBuilder = BeanDefinitionBuilder.rootBeanDefinition((String)PASSWD_AUTH_CLASS);
            String passwordAttribute = passwordCompareElt.getAttribute(ATT_USER_PASSWORD);
            if (StringUtils.hasText((String)passwordAttribute)) {
                authenticatorBuilder.addPropertyValue("passwordAttributeName", (Object)passwordAttribute);
            }
            Element passwordEncoderElement = DomUtils.getChildElementByTagName((Element)passwordCompareElt, (String)"password-encoder");
            String hash = passwordCompareElt.getAttribute(ATT_HASH);
            if (passwordEncoderElement != null) {
                if (StringUtils.hasText((String)hash)) {
                    parserContext.getReaderContext().warning("Attribute 'hash' cannot be used with 'password-encoder' and will be ignored.", parserContext.extractSource((Object)elt));
                }
                PasswordEncoderParser pep = new PasswordEncoderParser(passwordEncoderElement, parserContext);
                authenticatorBuilder.addPropertyValue("passwordEncoder", (Object)pep.getPasswordEncoder());
                if (pep.getSaltSource() != null) {
                    parserContext.getReaderContext().warning("Salt source information isn't valid when used with LDAP", (Object)passwordEncoderElement);
                }
            } else if (StringUtils.hasText((String)hash)) {
                authenticatorBuilder.addPropertyValue("passwordEncoder", (Object)PasswordEncoderParser.createPasswordEncoderBeanDefinition(hash, false));
            }
        }
        authenticatorBuilder.addConstructorArgValue((Object)contextSource);
        authenticatorBuilder.addPropertyValue("userDnPatterns", (Object)userDnPatternArray);
        if (searchBean != null) {
            authenticatorBuilder.addPropertyValue("userSearch", (Object)searchBean);
        }
        BeanDefinitionBuilder ldapProvider = BeanDefinitionBuilder.rootBeanDefinition((String)PROVIDER_CLASS);
        ldapProvider.addConstructorArgValue((Object)authenticatorBuilder.getBeanDefinition());
        ldapProvider.addConstructorArgValue((Object)LdapUserServiceBeanDefinitionParser.parseAuthoritiesPopulator(elt, parserContext));
        ldapProvider.addPropertyValue("userDetailsContextMapper", (Object)LdapUserServiceBeanDefinitionParser.parseUserDetailsClassOrUserMapperRef(elt, parserContext));
        return ldapProvider.getBeanDefinition();
    }
}

