/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.fileutils.digest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DigestUtil {
    public static String getDigestFileName() {
        return ".ahs.dig";
    }

    public static String parseDigestAlgorithm(String digest) {
        return digest.substring(0, digest.indexOf("{"));
    }

    public static String parseDigestHex(String digest) {
        return digest.substring(digest.indexOf("{") + 1, digest.length() - 1);
    }

    public static String getHexDigest(File file, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        FileInputStream in = new FileInputStream(file);
        return new DigestUtil().calculateHexDigest(in, digestAlgorithm);
    }

    public static List<String> getHexDigests(File file, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        FileInputStream in = new FileInputStream(file);
        return new DigestUtil().calculateHexDigests(in, digestAlgorithms);
    }

    public static String getHexDigest(byte[] bytes, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new DigestUtil().calculateHexDigest(in, digestAlgorithm);
    }

    public static List<String> getHexDigests(byte[] bytes, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new DigestUtil().calculateHexDigests(in, digestAlgorithms);
    }

    public static String getHexDigest(InputStream data, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        return new DigestUtil().calculateHexDigest(data, digestAlgorithm);
    }

    public static List<String> getHexDigests(InputStream data, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        return new DigestUtil().calculateHexDigests(data, digestAlgorithms);
    }

    public static String getBase64Digest(File file, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        FileInputStream in = new FileInputStream(file);
        return new DigestUtil().calculateBase64Digest(in, digestAlgorithm);
    }

    public static List<String> getBase64Digests(File file, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        FileInputStream in = new FileInputStream(file);
        return new DigestUtil().calculateBase64Digests(in, digestAlgorithms);
    }

    public static String getBase64Digest(byte[] bytes, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new DigestUtil().calculateBase64Digest(in, digestAlgorithm);
    }

    public static List<String> getBase64Digests(byte[] bytes, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new DigestUtil().calculateBase64Digests(in, digestAlgorithms);
    }

    public static String getBase64Digest(InputStream data, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        return new DigestUtil().calculateBase64Digest(data, digestAlgorithm);
    }

    public static List<String> getBase64Digests(InputStream data, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        return new DigestUtil().calculateBase64Digests(data, digestAlgorithms);
    }

    private DigestUtil() {
    }

    private String calculateHexDigest(InputStream in, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        return this.encodeHex(this.calculateDigestBytes(in, digestAlgorithm));
    }

    private List<String> calculateHexDigests(InputStream in, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        return this.encodeHex(this.calculateMultipleDigestBytes(in, digestAlgorithms));
    }

    private String calculateBase64Digest(InputStream in, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        return this.encodeBase64(this.calculateDigestBytes(in, digestAlgorithm));
    }

    private List<String> calculateBase64Digests(InputStream in, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        return this.encodeBase64(this.calculateMultipleDigestBytes(in, digestAlgorithms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] calculateDigestBytes(InputStream in, String digestAlgorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance(digestAlgorithm);
            byte[] buf = new byte[4096];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                digest.update(buf, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        byte[] digestBytes = digest.digest();
        return digestBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> calculateMultipleDigestBytes(InputStream in, String ... digestAlgorithms) throws NoSuchAlgorithmException, IOException {
        MessageDigest[] digests = new MessageDigest[digestAlgorithms.length];
        try {
            for (int i = 0; i < digestAlgorithms.length; ++i) {
                digests[i] = MessageDigest.getInstance(digestAlgorithms[i]);
            }
            byte[] buf = new byte[4096];
            int len = 0;
            while ((len = in.read(buf)) > 0) {
                for (int i = 0; i < digestAlgorithms.length; ++i) {
                    digests[i].update(buf, 0, len);
                }
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        ArrayList<byte[]> digestBytes = new ArrayList<byte[]>();
        for (int i = 0; i < digestAlgorithms.length; ++i) {
            digestBytes.add(digests[i].digest());
        }
        return digestBytes;
    }

    private String encodeHex(byte[] bytes) {
        return String.valueOf(Hex.encodeHex((byte[])bytes));
    }

    private List<String> encodeHex(List<byte[]> bytesList) {
        ArrayList<String> encodings = new ArrayList<String>(bytesList.size());
        for (byte[] bytes : bytesList) {
            encodings.add(String.valueOf(Hex.encodeHex((byte[])bytes)));
        }
        return encodings;
    }

    private String encodeBase64(byte[] bytes) {
        try {
            byte[] base64bytes = Base64.encodeBase64((byte[])bytes);
            return new String(base64bytes, "US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> encodeBase64(List<byte[]> bytesList) {
        try {
            ArrayList<String> encodings = new ArrayList<String>(bytesList.size());
            for (byte[] bytes : bytesList) {
                byte[] base64bytes = Base64.encodeBase64((byte[])bytes);
                encodings.add(new String(base64bytes, "US-ASCII"));
            }
            return encodings;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

