/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.http.ChannelAttributeFactory;
import org.springframework.security.config.http.FilterInvocationSecurityMetadataSourceParser;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.WebConfigUtils;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.access.intercept.RequestKey;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.util.AntUrlPathMatcher;
import org.springframework.security.web.util.UrlMatcher;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HttpConfigurationBuilder {
    private static final String ATT_CREATE_SESSION = "create-session";
    private static final String OPT_CREATE_SESSION_NEVER = "never";
    private static final String DEF_CREATE_SESSION_IF_REQUIRED = "ifRequired";
    private static final String OPT_CREATE_SESSION_ALWAYS = "always";
    private static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    private static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    private static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    private static final String ATT_INVALID_SESSION_URL = "invalid-session-url";
    private static final String ATT_SESSION_AUTH_STRATEGY_REF = "session-authentication-strategy-ref";
    private static final String ATT_SESSION_AUTH_ERROR_URL = "session-authentication-error-url";
    private static final String ATT_SECURITY_CONTEXT_REPOSITORY = "security-context-repository-ref";
    private static final String ATT_DISABLE_URL_REWRITING = "disable-url-rewriting";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    private final Element httpElt;
    private final ParserContext pc;
    private final UrlMatcher matcher;
    private final Boolean convertPathsToLowerCase;
    private final boolean allowSessionCreation;
    private final List<Element> interceptUrls;
    private ManagedMap<Object, List<BeanMetadataElement>> filterChainMap;
    private BeanDefinition cpf;
    private BeanDefinition securityContextPersistenceFilter;
    private BeanReference contextRepoRef;
    private BeanReference sessionRegistryRef;
    private BeanDefinition concurrentSessionFilter;
    private BeanReference sessionStrategyRef;
    private RootBeanDefinition sfpf;
    private BeanDefinition servApiFilter;
    private String portMapperName;
    private BeanReference fsi;

    public HttpConfigurationBuilder(Element element, ParserContext pc, UrlMatcher matcher, String portMapperName) {
        this.httpElt = element;
        this.pc = pc;
        this.portMapperName = portMapperName;
        this.matcher = matcher;
        this.convertPathsToLowerCase = matcher instanceof AntUrlPathMatcher && matcher.requiresLowerCaseUrl();
        this.interceptUrls = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        this.allowSessionCreation = !OPT_CREATE_SESSION_NEVER.equals(element.getAttribute(ATT_CREATE_SESSION));
    }

    void parseInterceptUrlsForEmptyFilterChains() {
        this.filterChainMap = new ManagedMap();
        for (Element urlElt : this.interceptUrls) {
            String path = urlElt.getAttribute("pattern");
            if (!StringUtils.hasText((String)path)) {
                this.pc.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            BeanDefinitionBuilder pathBean = BeanDefinitionBuilder.rootBeanDefinition(HttpConfigurationBuilder.class);
            pathBean.setFactoryMethod("createPath");
            pathBean.addConstructorArgValue((Object)path);
            pathBean.addConstructorArgValue((Object)this.convertPathsToLowerCase);
            String filters = urlElt.getAttribute("filters");
            if (!StringUtils.hasText((String)filters)) continue;
            if (!filters.equals(OPT_SESSION_FIXATION_NO_PROTECTION)) {
                this.pc.getReaderContext().error("Currently only 'none' is supported as the custom filters attribute", (Object)urlElt);
            }
            List noFilters = Collections.emptyList();
            this.filterChainMap.put((Object)pathBean.getBeanDefinition(), noFilters);
        }
    }

    static String createPath(String path, boolean lowerCase) {
        return lowerCase ? path.toLowerCase() : path;
    }

    void createSecurityContextPersistenceFilter() {
        BeanDefinitionBuilder scpf = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextPersistenceFilter.class);
        String repoRef = this.httpElt.getAttribute(ATT_SECURITY_CONTEXT_REPOSITORY);
        String createSession = this.httpElt.getAttribute(ATT_CREATE_SESSION);
        String disableUrlRewriting = this.httpElt.getAttribute(ATT_DISABLE_URL_REWRITING);
        if (StringUtils.hasText((String)repoRef)) {
            if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
            } else if (StringUtils.hasText((String)createSession)) {
                this.pc.getReaderContext().error("If using security-context-repository-ref, the only value you can set for 'create-session' is 'always'. Other session creation logic should be handled by the SecurityContextRepository", (Object)this.httpElt);
            }
        } else {
            BeanDefinitionBuilder contextRepo = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSecurityContextRepository.class);
            if (OPT_CREATE_SESSION_ALWAYS.equals(createSession)) {
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
            } else if (OPT_CREATE_SESSION_NEVER.equals(createSession)) {
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.FALSE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
            } else {
                createSession = DEF_CREATE_SESSION_IF_REQUIRED;
                contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
            }
            if ("true".equals(disableUrlRewriting)) {
                contextRepo.addPropertyValue("disableUrlRewriting", (Object)Boolean.TRUE);
            }
            AbstractBeanDefinition repoBean = contextRepo.getBeanDefinition();
            repoRef = this.pc.getReaderContext().generateBeanName((BeanDefinition)repoBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)repoBean, repoRef));
        }
        this.contextRepoRef = new RuntimeBeanReference(repoRef);
        scpf.addPropertyValue("securityContextRepository", (Object)this.contextRepoRef);
        this.securityContextPersistenceFilter = scpf.getBeanDefinition();
    }

    void createSessionManagementFilters() {
        BeanDefinitionBuilder sessionStrategy;
        boolean sessionFixationProtectionRequired;
        Element sessionMgmtElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"session-management");
        Element sessionCtrlElt = null;
        String sessionFixationAttribute = null;
        String invalidSessionUrl = null;
        String sessionAuthStratRef = null;
        String errorUrl = null;
        if (sessionMgmtElt != null) {
            sessionFixationAttribute = sessionMgmtElt.getAttribute(ATT_SESSION_FIXATION_PROTECTION);
            invalidSessionUrl = sessionMgmtElt.getAttribute(ATT_INVALID_SESSION_URL);
            sessionAuthStratRef = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_STRATEGY_REF);
            errorUrl = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_ERROR_URL);
            sessionCtrlElt = DomUtils.getChildElementByTagName((Element)sessionMgmtElt, (String)"concurrency-control");
            if (sessionCtrlElt != null) {
                if (StringUtils.hasText((String)sessionAuthStratRef)) {
                    this.pc.getReaderContext().error("session-authentication-strategy-ref attribute cannot be used in combination with <concurrency-control>", this.pc.extractSource((Object)sessionCtrlElt));
                }
                this.createConcurrencyControlFilterAndSessionRegistry(sessionCtrlElt);
            }
        }
        if (!StringUtils.hasText(sessionFixationAttribute)) {
            sessionFixationAttribute = OPT_SESSION_FIXATION_MIGRATE_SESSION;
        } else if (StringUtils.hasText(sessionAuthStratRef)) {
            this.pc.getReaderContext().error("session-fixation-protection attribute cannot be used in combination with session-authentication-strategy-ref", this.pc.extractSource(sessionCtrlElt));
        }
        boolean bl = sessionFixationProtectionRequired = !sessionFixationAttribute.equals(OPT_SESSION_FIXATION_NO_PROTECTION);
        if (sessionCtrlElt != null) {
            String exceptionIfMaximumExceeded;
            assert (this.sessionRegistryRef != null);
            sessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionControlStrategy.class);
            sessionStrategy.addConstructorArgValue((Object)this.sessionRegistryRef);
            String maxSessions = sessionCtrlElt.getAttribute("max-sessions");
            if (StringUtils.hasText((String)maxSessions)) {
                sessionStrategy.addPropertyValue("maximumSessions", (Object)maxSessions);
            }
            if (StringUtils.hasText((String)(exceptionIfMaximumExceeded = sessionCtrlElt.getAttribute("error-if-maximum-exceeded")))) {
                sessionStrategy.addPropertyValue("exceptionIfMaximumExceeded", (Object)exceptionIfMaximumExceeded);
            }
        } else if (sessionFixationProtectionRequired || StringUtils.hasText((String)invalidSessionUrl) || StringUtils.hasText((String)sessionAuthStratRef)) {
            sessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(SessionFixationProtectionStrategy.class);
        } else {
            this.sfpf = null;
            return;
        }
        BeanDefinitionBuilder sessionMgmtFilter = BeanDefinitionBuilder.rootBeanDefinition(SessionManagementFilter.class);
        RootBeanDefinition failureHandler = new RootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
        if (StringUtils.hasText((String)errorUrl)) {
            failureHandler.getPropertyValues().addPropertyValue("defaultFailureUrl", (Object)errorUrl);
        }
        sessionMgmtFilter.addPropertyValue("authenticationFailureHandler", (Object)failureHandler);
        sessionMgmtFilter.addConstructorArgValue((Object)this.contextRepoRef);
        if (!StringUtils.hasText((String)sessionAuthStratRef)) {
            AbstractBeanDefinition strategyBean = sessionStrategy.getBeanDefinition();
            if (sessionFixationProtectionRequired) {
                sessionStrategy.addPropertyValue("migrateSessionAttributes", (Object)sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
            }
            sessionAuthStratRef = this.pc.getReaderContext().generateBeanName((BeanDefinition)strategyBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)strategyBean, sessionAuthStratRef));
        }
        if (StringUtils.hasText((String)invalidSessionUrl)) {
            sessionMgmtFilter.addPropertyValue("invalidSessionUrl", (Object)invalidSessionUrl);
        }
        sessionMgmtFilter.addPropertyReference("sessionAuthenticationStrategy", sessionAuthStratRef);
        this.sfpf = (RootBeanDefinition)sessionMgmtFilter.getBeanDefinition();
        this.sessionStrategyRef = new RuntimeBeanReference(sessionAuthStratRef);
    }

    private void createConcurrencyControlFilterAndSessionRegistry(Element element) {
        String registryAlias;
        String ATT_EXPIRY_URL = "expired-url";
        String ATT_SESSION_REGISTRY_ALIAS = "session-registry-alias";
        String ATT_SESSION_REGISTRY_REF = "session-registry-ref";
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), this.pc.extractSource((Object)element));
        this.pc.pushContainingComponent(compositeDef);
        BeanDefinitionRegistry beanRegistry = this.pc.getRegistry();
        String sessionRegistryId = element.getAttribute("session-registry-ref");
        if (!StringUtils.hasText((String)sessionRegistryId)) {
            RootBeanDefinition sessionRegistry = new RootBeanDefinition(SessionRegistryImpl.class);
            sessionRegistryId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)sessionRegistry);
            this.pc.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sessionRegistry, sessionRegistryId));
        }
        if (StringUtils.hasText((String)(registryAlias = element.getAttribute("session-registry-alias")))) {
            beanRegistry.registerAlias(sessionRegistryId, registryAlias);
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionFilter.class);
        filterBuilder.addPropertyReference("sessionRegistry", sessionRegistryId);
        Object source = this.pc.extractSource((Object)element);
        filterBuilder.getRawBeanDefinition().setSource(source);
        filterBuilder.setRole(2);
        String expiryUrl = element.getAttribute("expired-url");
        if (StringUtils.hasText((String)expiryUrl)) {
            WebConfigUtils.validateHttpRedirect(expiryUrl, this.pc, source);
            filterBuilder.addPropertyValue("expiredUrl", (Object)expiryUrl);
        }
        this.pc.popAndRegisterContainingComponent();
        this.concurrentSessionFilter = filterBuilder.getBeanDefinition();
        this.sessionRegistryRef = new RuntimeBeanReference(sessionRegistryId);
    }

    void createServletApiFilter() {
        String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
        String DEF_SERVLET_API_PROVISION = "true";
        String provideServletApi = this.httpElt.getAttribute("servlet-api-provision");
        if (!StringUtils.hasText((String)provideServletApi)) {
            provideServletApi = "true";
        }
        if ("true".equals(provideServletApi)) {
            this.servApiFilter = new RootBeanDefinition(SecurityContextHolderAwareRequestFilter.class);
        }
    }

    void createChannelProcessingFilter() {
        ManagedMap<BeanDefinition, BeanDefinition> channelRequestMap = this.parseInterceptUrlsForChannelSecurity();
        if (channelRequestMap.isEmpty()) {
            return;
        }
        RootBeanDefinition channelFilter = new RootBeanDefinition(ChannelProcessingFilter.class);
        BeanDefinitionBuilder metadataSourceBldr = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
        metadataSourceBldr.addConstructorArgValue((Object)this.matcher);
        metadataSourceBldr.addConstructorArgValue(channelRequestMap);
        metadataSourceBldr.addPropertyValue("stripQueryStringFromUrls", (Object)(this.matcher instanceof AntUrlPathMatcher));
        channelFilter.getPropertyValues().addPropertyValue("securityMetadataSource", (Object)metadataSourceBldr.getBeanDefinition());
        RootBeanDefinition channelDecisionManager = new RootBeanDefinition(ChannelDecisionManagerImpl.class);
        ManagedList channelProcessors = new ManagedList(3);
        RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(SecureChannelProcessor.class);
        RootBeanDefinition retryWithHttp = new RootBeanDefinition(RetryWithHttpEntryPoint.class);
        RootBeanDefinition retryWithHttps = new RootBeanDefinition(RetryWithHttpsEntryPoint.class);
        RuntimeBeanReference portMapper = new RuntimeBeanReference(this.portMapperName);
        retryWithHttp.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        retryWithHttps.getPropertyValues().addPropertyValue("portMapper", (Object)portMapper);
        secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttps);
        RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(InsecureChannelProcessor.class);
        inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttp);
        channelProcessors.add((Object)secureChannelProcessor);
        channelProcessors.add((Object)inSecureChannelProcessor);
        channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", (Object)channelProcessors);
        String id = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)channelDecisionManager);
        channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", (Object)new RuntimeBeanReference(id));
        this.cpf = channelFilter;
    }

    private ManagedMap<BeanDefinition, BeanDefinition> parseInterceptUrlsForChannelSecurity() {
        ManagedMap channelRequestMap = new ManagedMap();
        for (Element urlElt : this.interceptUrls) {
            String requiredChannel;
            String path = urlElt.getAttribute("pattern");
            if (!StringUtils.hasText((String)path)) {
                this.pc.getReaderContext().error("path attribute cannot be empty or null", (Object)urlElt);
            }
            if (this.convertPathsToLowerCase.booleanValue()) {
                path = path.toLowerCase();
            }
            if (!StringUtils.hasText((String)(requiredChannel = urlElt.getAttribute("requires-channel")))) continue;
            RootBeanDefinition requestKey = new RootBeanDefinition(RequestKey.class);
            requestKey.getConstructorArgumentValues().addGenericArgumentValue((Object)path);
            String method = urlElt.getAttribute("method");
            if (StringUtils.hasText((String)method)) {
                requestKey.getConstructorArgumentValues().addGenericArgumentValue((Object)method);
            }
            RootBeanDefinition channelAttributes = new RootBeanDefinition(ChannelAttributeFactory.class);
            channelAttributes.getConstructorArgumentValues().addGenericArgumentValue((Object)requiredChannel);
            channelAttributes.setFactoryMethodName("createChannelAttributes");
            channelRequestMap.put((Object)requestKey, (Object)channelAttributes);
        }
        return channelRequestMap;
    }

    void createFilterSecurityInterceptor(BeanReference authManager) {
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(this.httpElt);
        BeanDefinition securityMds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(this.interceptUrls, this.httpElt, this.pc);
        ManagedList voters = new ManagedList(2);
        if (useExpressions) {
            voters.add((Object)new RootBeanDefinition(WebExpressionVoter.class));
        } else {
            voters.add((Object)new RootBeanDefinition(RoleVoter.class));
            voters.add((Object)new RootBeanDefinition(AuthenticatedVoter.class));
        }
        RootBeanDefinition accessDecisionMgr = new RootBeanDefinition(AffirmativeBased.class);
        accessDecisionMgr.getPropertyValues().addPropertyValue("decisionVoters", (Object)voters);
        accessDecisionMgr.setSource(this.pc.extractSource((Object)this.httpElt));
        String accessManagerId = this.httpElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            accessManagerId = this.pc.getReaderContext().generateBeanName((BeanDefinition)accessDecisionMgr);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)accessDecisionMgr, accessManagerId));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FilterSecurityInterceptor.class);
        builder.addPropertyReference("accessDecisionManager", accessManagerId);
        builder.addPropertyValue("authenticationManager", (Object)authManager);
        if ("false".equals(this.httpElt.getAttribute(ATT_ONCE_PER_REQUEST))) {
            builder.addPropertyValue("observeOncePerRequest", (Object)Boolean.FALSE);
        }
        builder.addPropertyValue("securityMetadataSource", (Object)securityMds);
        AbstractBeanDefinition fsiBean = builder.getBeanDefinition();
        String fsiId = this.pc.getReaderContext().generateBeanName((BeanDefinition)fsiBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)fsiBean, fsiId));
        RootBeanDefinition wipe = new RootBeanDefinition(DefaultWebInvocationPrivilegeEvaluator.class);
        wipe.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(fsiId));
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)wipe, this.pc.getReaderContext().generateBeanName((BeanDefinition)wipe)));
        this.fsi = new RuntimeBeanReference(fsiId);
    }

    BeanReference getSessionStrategy() {
        return this.sessionStrategyRef;
    }

    boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public ManagedMap<Object, List<BeanMetadataElement>> getFilterChainMap() {
        return this.filterChainMap;
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.cpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.cpf, SecurityFilters.CHANNEL_FILTER));
        }
        if (this.concurrentSessionFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.concurrentSessionFilter, SecurityFilters.CONCURRENT_SESSION_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.securityContextPersistenceFilter, SecurityFilters.SECURITY_CONTEXT_FILTER));
        if (this.servApiFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.servApiFilter, SecurityFilters.SERVLET_API_SUPPORT_FILTER));
        }
        if (this.sfpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.sfpf, SecurityFilters.SESSION_MANAGEMENT_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.fsi, SecurityFilters.FILTER_SECURITY_INTERCEPTOR));
        return filters;
    }
}

