/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.server.xml;

import com.urbancode.air.plugin.server.ext.PluginCommandPropertyUIExtension;
import com.urbancode.air.plugin.server.ext.PluginCommandPropertyUIType;
import com.urbancode.air.plugin_command.AutomationPlugin;
import com.urbancode.air.plugin_command.Command;
import com.urbancode.air.plugin_command.Extension;
import com.urbancode.air.plugin_command.properties.PluginCommandProperty;
import com.urbancode.air.plugin_command.properties.SelectValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServerPluginXMLContentHandler
extends DefaultHandler {
    public static final String PLUGIN_ELEMENT = "plugin";
    public static final String HEADER_ELEMENT = "header";
    public static final String TAG_ELEMENT = "tag";
    public static final String REQUIRED_SERVER_VERSION_ELEMENT = "required-server-version";
    public static final String ARG_ELEMENT = "arg";
    public static final String COMMAND_ELEMENT = "command";
    public static final String IDENTIFIER_ELEMENT = "identifier";
    public static final String DEFAULT_VALUE_ELEMENT = "default-value";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String POST_PROCESSING_ELEMENT = "post-processing";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String PROPERTY_UI_ELEMENT = "property-ui";
    public static final String STEP_TYPE_ELEMENT = "step-type";
    public static final String VALUE_ELEMENT = "value";
    public static final String ENVIRONMENT_ELEMENT = "env";
    public static final String ENVIRONMENT_PROP_ELEMENT = "prop-ref";
    public static final String DEFAULT_VALUE_ATTRIBUTE = "default-value";
    public static final String DESCRIPTION_ATTRIBUTE = "description";
    public static final String PLACEHOLDER_ATTRIBUTE = "placeholder";
    public static final String HIDDEN_ATTRIBUTE = "hidden";
    public static final String LABEL_ATTRIBUTE = "label";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String ID_ATTRIBUTE = "id";
    public static final String FILE_ATTRIBUTE = "file";
    public static final String VERSION_ATTRIBUTE = "version";
    public static final String REQUIRED_ATTRIBUTE = "required";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String PROGRAM_ATTRIBUTE = "program";
    public static final String PATH_ATTRIBUTE = "path";
    protected Stack<String> tagNameStack = new Stack();
    protected AutomationPlugin plugin = null;
    protected Command curCommand = null;
    protected PluginCommandProperty curProp = null;
    protected List<Command> commands = new ArrayList<Command>();
    protected String id = null;
    protected String name = null;
    protected String versionString = null;
    protected String pluginDescription = null;
    protected String tag = null;
    protected String requiredServerVersion = null;
    protected String curAllowedValueLabel = null;
    protected String curAllowedValueValue = null;
    protected boolean hasPropUi = false;
    protected boolean hasCommand = false;
    protected boolean hasProperties = false;
    protected boolean hasTag = false;
    protected boolean hasRequiredServerVersion = false;
    protected boolean hasIdent = false;
    protected boolean hasValue = false;
    protected boolean hasPostProcessing = false;
    protected boolean hasHeader = false;
    protected StringBuilder tagText = new StringBuilder();

    public void startElement(String ns, String localName, String qName, Attributes attrs) throws SAXException {
        if (localName.equals(PLUGIN_ELEMENT)) {
            this.handlePluginStart(attrs);
        } else if (localName.equals(HEADER_ELEMENT)) {
            this.handleHeaderStart(attrs);
        } else if (localName.equals(IDENTIFIER_ELEMENT)) {
            this.handleIdentifierStart(attrs);
        } else if (localName.equals("description")) {
            this.handleDescriptionStart(attrs);
        } else if (localName.equals("default-value")) {
            this.handleDefaultValueStart(attrs);
        } else if (localName.equals(TAG_ELEMENT)) {
            this.handleTagStart(attrs);
        } else if (localName.equals(REQUIRED_SERVER_VERSION_ELEMENT)) {
            this.handleRequiredServerVersionStart(attrs);
        } else if (localName.equals(STEP_TYPE_ELEMENT)) {
            this.handleStepTypeStart(attrs);
        } else if (localName.equals(PROPERTIES_ELEMENT)) {
            this.handlePropertiesStart(attrs);
        } else if (localName.equals(PROPERTY_ELEMENT)) {
            this.handlePropertyStart(attrs);
        } else if (localName.equals(PROPERTY_UI_ELEMENT)) {
            this.handlePropertyUIStart(attrs);
        } else if (localName.equals(VALUE_ELEMENT)) {
            this.handleValueStart(attrs);
        } else if (localName.equals(POST_PROCESSING_ELEMENT)) {
            this.handlePostProcessingStart(attrs);
        } else if (localName.equals(COMMAND_ELEMENT)) {
            this.handleCommandStart(attrs);
        } else if (localName.equals(ARG_ELEMENT)) {
            this.handleArgStart(attrs);
        } else if (!localName.equals(ENVIRONMENT_ELEMENT) && !localName.equals(ENVIRONMENT_PROP_ELEMENT)) {
            throw new SAXException("Unknown element:" + localName);
        }
        this.tagNameStack.push(localName);
        this.tagText = new StringBuilder();
    }

    public void endElement(String ns, String localName, String qName) throws SAXException {
        if (localName.equals(PLUGIN_ELEMENT)) {
            this.handlePluginEnd();
        } else if (localName.equals(HEADER_ELEMENT)) {
            this.handleHeaderEnd();
        } else if (localName.equals(IDENTIFIER_ELEMENT)) {
            this.handleIdentifierEnd();
        } else if (localName.equals("description")) {
            this.handleDescriptionEnd();
        } else if (localName.equals("default-value")) {
            this.handleDefaultValueEnd();
        } else if (localName.equals(TAG_ELEMENT)) {
            this.handleTagEnd();
        } else if (localName.equals(REQUIRED_SERVER_VERSION_ELEMENT)) {
            this.handleRequiredServerVersionEnd();
        } else if (localName.equals(STEP_TYPE_ELEMENT)) {
            this.handleStepTypeEnd();
        } else if (localName.equals(PROPERTIES_ELEMENT)) {
            this.handlePropertiesEnd();
        } else if (localName.equals(PROPERTY_ELEMENT)) {
            this.handlePropertyEnd();
        } else if (localName.equals(PROPERTY_UI_ELEMENT)) {
            this.handlePropertyUIEnd();
        } else if (localName.equals(VALUE_ELEMENT)) {
            this.handleValueEnd();
        } else if (localName.equals(POST_PROCESSING_ELEMENT)) {
            this.handlePostProcessingEnd();
        } else if (localName.equals(COMMAND_ELEMENT)) {
            this.handleCommandEnd();
        } else if (localName.equals(ARG_ELEMENT)) {
            this.handleArgEnd();
        }
        this.tagNameStack.pop();
        this.tagText = new StringBuilder();
    }

    public void characters(char[] chars, int start, int length) throws SAXException {
        this.tagText.append(chars, start, length);
    }

    protected void handlePluginStart(Attributes attrs) throws SAXException {
        if (!this.tagNameStack.isEmpty()) {
            throw new SAXException("element plugin has to be the root element!");
        }
        if (attrs.getLength() != 0) {
            throw new SAXException("plugin should not have any attributes on it.");
        }
    }

    protected void handlePluginEnd() throws SAXException {
        if (!this.hasHeader) {
            throw new SAXException("All plugins must have a header element!");
        }
        this.hasHeader = false;
        for (Command command : this.commands) {
            this.plugin.addCommand(command);
        }
    }

    protected void handleHeaderStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PLUGIN_ELEMENT, HEADER_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("header should not have any attributes on it.");
        }
        if (this.hasHeader) {
            throw new SAXException("plugin can have only one header");
        }
        this.hasHeader = true;
    }

    protected void handleHeaderEnd() throws SAXException {
        if (!this.hasIdent) {
            throw new SAXException("header element must contain an identifier");
        }
        if (!this.hasTag) {
            throw new SAXException("header element must contain an tag");
        }
        this.hasIdent = false;
        this.hasTag = false;
        this.plugin = new AutomationPlugin(this.id, this.name, Long.valueOf(this.versionString).longValue(), this.pluginDescription, this.tag, this.requiredServerVersion);
    }

    protected void handleIdentifierStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(HEADER_ELEMENT, IDENTIFIER_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(ID_ATTRIBUTE)) {
                this.id = attrValue;
                continue;
            }
            if (attrName.equals(NAME_ATTRIBUTE)) {
                this.name = attrValue;
                continue;
            }
            if (attrName.equals(VERSION_ATTRIBUTE)) {
                this.versionString = attrValue;
                continue;
            }
            throw new SAXException("Unknown attribute on identifier element: " + attrName);
        }
        if (this.id == null) {
            throw new SAXException("id not found from the identifier tag in the header tag.");
        }
        if (this.name == null) {
            throw new SAXException("name not found from the identifier tag in the header tag.");
        }
        if (this.versionString == null) {
            throw new SAXException("version not found from the identifier tag in the header tag.");
        }
        if (this.hasIdent) {
            throw new SAXException("header can have only one identifier");
        }
        this.hasIdent = true;
    }

    protected void checkParentElementType(String expectedParent, String elementName) throws SAXException {
        this.checkParentElementType(new String[]{expectedParent}, elementName);
    }

    protected void checkParentElementType(String[] expectedParents, String elementName) throws SAXException {
        boolean hasGoodParent = false;
        String actualParent = this.tagNameStack.peek();
        for (String expectedParent : expectedParents) {
            if (!expectedParent.equals(actualParent)) continue;
            hasGoodParent = true;
            break;
        }
        if (!hasGoodParent) {
            String errString = elementName + " element can only appear in one of the " + "following elements :";
            boolean first = true;
            for (String expectedParent : expectedParents) {
                if (first) {
                    errString = errString + expectedParent;
                    first = false;
                    continue;
                }
                errString = errString + ", " + expectedParent;
            }
            errString = errString + "\n not :";
            boolean firstTag = true;
            while (!this.tagNameStack.isEmpty()) {
                String tagNamePar = this.tagNameStack.pop();
                if (firstTag) {
                    errString = errString + tagNamePar;
                    firstTag = false;
                    continue;
                }
                errString = errString + "->" + tagNamePar;
            }
            throw new SAXException(errString);
        }
    }

    protected void handleIdentifierEnd() throws SAXException {
    }

    protected void handleDescriptionStart(Attributes attrs) throws SAXException {
        if (attrs.getLength() != 0) {
            throw new SAXException("description should not have any attributes on it.");
        }
    }

    protected void handleDescriptionEnd() throws SAXException {
        String parentElementName = (String)this.tagNameStack.get(this.tagNameStack.size() - 2);
        String val = this.tagText.toString().trim();
        if (parentElementName.equals(HEADER_ELEMENT)) {
            this.pluginDescription = val;
        } else if (parentElementName.equals(STEP_TYPE_ELEMENT)) {
            this.curCommand.setDescription(val);
        } else {
            throw new SAXException("description not allowed in: " + parentElementName);
        }
    }

    protected void handleDefaultValueStart(Attributes attrs) throws SAXException {
        if (attrs.getLength() != 0) {
            throw new SAXException("default-value should not have any attributes on it.");
        }
    }

    protected void handleDefaultValueEnd() throws SAXException {
        String parentElementName = (String)this.tagNameStack.get(this.tagNameStack.size() - 2);
        String defaultValue = this.tagText.toString().trim();
        if (!parentElementName.equals(PROPERTY_UI_ELEMENT)) {
            throw new SAXException("default-value not allowed in: " + parentElementName);
        }
        PluginCommandPropertyUIExtension extension = (PluginCommandPropertyUIExtension)this.curProp.getExtension();
        extension.setDefaultValue(defaultValue);
    }

    protected void handleTagStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(HEADER_ELEMENT, TAG_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("tag should not have any attributes on it.");
        }
        if (this.hasTag) {
            throw new SAXException("header can only have one tag");
        }
        this.hasTag = true;
    }

    protected void handleTagEnd() throws SAXException {
        String val;
        this.tag = val = this.tagText.toString().trim();
    }

    protected void handleRequiredServerVersionStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(HEADER_ELEMENT, REQUIRED_SERVER_VERSION_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("required-server-version should not have any attributes on it.");
        }
        if (this.hasRequiredServerVersion) {
            throw new SAXException("header can only have one required-server-version");
        }
        this.hasRequiredServerVersion = true;
    }

    protected void handleRequiredServerVersionEnd() throws SAXException {
        String val;
        this.requiredServerVersion = val = this.tagText.toString().trim();
    }

    protected void handleStepTypeStart(Attributes attrs) throws SAXException {
        String name = null;
        this.checkParentElementType(PLUGIN_ELEMENT, STEP_TYPE_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (!attrName.equals(NAME_ATTRIBUTE)) {
                throw new SAXException("Unknown attribute on step-type : " + attrName);
            }
            name = attrValue;
        }
        if (name == null) {
            throw new SAXException("name is a required attribute on step-type");
        }
        this.curCommand = new Command(name, "");
    }

    protected void handleStepTypeEnd() throws SAXException {
        if (!this.hasCommand) {
            throw new SAXException("step-type has to have a command");
        }
        if (!this.hasProperties) {
            throw new SAXException("step-type has to have a properties");
        }
        if (!this.hasPostProcessing) {
            throw new SAXException("step-type has to have a post-processing");
        }
        this.hasPostProcessing = false;
        this.hasProperties = false;
        this.hasCommand = false;
        this.commands.add(this.curCommand);
        this.curCommand = null;
    }

    protected void handlePropertiesStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(STEP_TYPE_ELEMENT, PROPERTIES_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("properties element should have no attributes!");
        }
        this.hasProperties = true;
    }

    protected void handlePropertiesEnd() throws SAXException {
    }

    protected void handlePropertyStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(new String[]{PROPERTIES_ELEMENT}, PROPERTY_ELEMENT);
        String name = null;
        Boolean required = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(NAME_ATTRIBUTE)) {
                name = attrValue;
                continue;
            }
            if (attrName.equals(REQUIRED_ATTRIBUTE)) {
                required = Boolean.valueOf(attrValue);
                continue;
            }
            throw new SAXException("Unknown attribute on property element " + attrName);
        }
        if (name == null) {
            throw new SAXException("name is a required attribute on property");
        }
        PluginCommandProperty prop = new PluginCommandProperty(name, required.booleanValue(), null);
        this.curCommand.addPluginProp(prop);
        this.curProp = prop;
    }

    protected void handlePropertyEnd() throws SAXException {
        if (!this.hasPropUi) {
            throw new SAXException("All properties must have a property-ui. None found in property named " + this.curProp.getName() + " at location " + this.getTagStackPath());
        }
        this.hasPropUi = false;
        this.curProp = null;
    }

    protected void handlePropertyUIStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PROPERTY_ELEMENT, PROPERTY_UI_ELEMENT);
        Object type = null;
        PluginCommandPropertyUIType propType = null;
        String label = null;
        String description = null;
        String placeholder = null;
        String defaultValue = null;
        Boolean hidden = false;
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (attrName.equals(LABEL_ATTRIBUTE)) {
                label = attrValue;
                continue;
            }
            if (attrName.equals("description")) {
                description = attrValue.replaceAll("\\s+", " ");
                continue;
            }
            if (attrName.equals(PLACEHOLDER_ATTRIBUTE)) {
                placeholder = attrValue;
                continue;
            }
            if (attrName.equals("default-value")) {
                defaultValue = attrValue;
                continue;
            }
            if (attrName.equals(HIDDEN_ATTRIBUTE)) {
                hidden = Boolean.valueOf(attrValue);
                continue;
            }
            if (attrName.equals(TYPE_ATTRIBUTE)) {
                propType = PluginCommandPropertyUIType.valueOf(attrValue);
                continue;
            }
            throw new SAXException("Unknown attribute on property-ui : " + attrName);
        }
        if (label == null) {
            label = this.curProp.getName();
        }
        if (type == null && propType == null) {
            throw new SAXException("type is a required attribute on property-ui");
        }
        PluginCommandPropertyUIExtension ext = new PluginCommandPropertyUIExtension(propType, label, description, defaultValue, hidden);
        this.curProp.setExtension((Extension)ext);
        this.hasPropUi = true;
    }

    protected void handlePropertyUIEnd() throws SAXException {
    }

    protected void handleValueStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(PROPERTY_ELEMENT, VALUE_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            String attrValue = attrs.getValue(i);
            if (!attrName.equals(LABEL_ATTRIBUTE)) {
                throw new SAXException("Unknown attribute " + attrName + " on " + VALUE_ELEMENT);
            }
            this.curAllowedValueLabel = attrValue;
        }
        if (this.curAllowedValueLabel == null) {
            throw new SAXException("label is a required attribute on value");
        }
    }

    protected void handleValueEnd() throws SAXException {
        String val;
        this.curAllowedValueValue = val = this.tagText.toString().trim();
        SelectValue value = new SelectValue(this.curAllowedValueLabel, this.curAllowedValueValue);
        this.curProp.addAllowedValue(value);
        this.curAllowedValueLabel = null;
        this.curAllowedValueValue = null;
    }

    protected void handlePostProcessingStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(STEP_TYPE_ELEMENT, POST_PROCESSING_ELEMENT);
        if (attrs.getLength() != 0) {
            throw new SAXException("post-processing should not have any attributes on it!");
        }
    }

    protected void handlePostProcessingEnd() throws SAXException {
        String postProcessingScript = this.tagText.toString().trim();
        this.hasPostProcessing = StringUtils.isNotBlank((String)postProcessingScript);
        this.curCommand.setPostProcessingScript(postProcessingScript);
    }

    protected void handleCommandStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(STEP_TYPE_ELEMENT, COMMAND_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            if (attrName.equals(PROGRAM_ATTRIBUTE)) continue;
            throw new SAXException("Unknown attribute in command : " + attrName);
        }
        if (this.hasCommand) {
            throw new SAXException("step-type can have only one command");
        }
        this.hasCommand = true;
    }

    protected void handleCommandEnd() throws SAXException {
    }

    protected void handleArgStart(Attributes attrs) throws SAXException {
        this.checkParentElementType(COMMAND_ELEMENT, ARG_ELEMENT);
        for (int i = 0; i < attrs.getLength(); ++i) {
            String attrName = attrs.getLocalName(i);
            if (attrName.equals(PATH_ATTRIBUTE) || attrName.equals(VALUE_ELEMENT) || attrName.equals(FILE_ATTRIBUTE)) continue;
            throw new SAXException("Unknown attribute on arg : " + attrName);
        }
    }

    protected void handleArgEnd() throws SAXException {
    }

    public AutomationPlugin getPlugin() {
        return this.plugin;
    }

    protected String getTagStackPath() {
        return this.tagNameStack.toString();
    }
}

