/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ldap.search;

import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.support.BaseLdapPathContextSource;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.util.Assert;

public class FilterBasedLdapUserSearch
implements LdapUserSearch {
    private static final Log logger = LogFactory.getLog(FilterBasedLdapUserSearch.class);
    private ContextSource contextSource;
    private SearchControls searchControls = new SearchControls();
    private String searchBase = "";
    private String searchFilter;

    public FilterBasedLdapUserSearch(String searchBase, String searchFilter, BaseLdapPathContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"contextSource must not be null");
        Assert.notNull((Object)searchFilter, (String)"searchFilter must not be null.");
        Assert.notNull((Object)searchBase, (String)"searchBase must not be null (an empty string is acceptable).");
        this.searchFilter = searchFilter;
        this.contextSource = contextSource;
        this.searchBase = searchBase;
        this.setSearchSubtree(true);
        if (searchBase.length() == 0) {
            logger.info((Object)("SearchBase not set. Searches will be performed from the root: " + contextSource.getBaseLdapPath()));
        }
    }

    public DirContextOperations searchForUser(String username) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Searching for user '" + username + "', with user search " + this));
        }
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(this.contextSource);
        template.setSearchControls(this.searchControls);
        try {
            return template.searchForSingleEntry(this.searchBase, this.searchFilter, new String[]{username});
        }
        catch (IncorrectResultSizeDataAccessException notFound) {
            if (notFound.getActualSize() == 0) {
                throw new UsernameNotFoundException("User " + username + " not found in directory.", (Object)username);
            }
            throw notFound;
        }
    }

    public void setDerefLinkFlag(boolean deref) {
        this.searchControls.setDerefLinkFlag(deref);
    }

    public void setSearchSubtree(boolean searchSubtree) {
        this.searchControls.setSearchScope(searchSubtree ? 2 : 1);
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchControls.setTimeLimit(searchTimeLimit);
    }

    public void setReturningAttributes(String[] attrs) {
        this.searchControls.setReturningAttributes(attrs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ searchFilter: '").append(this.searchFilter).append("', ");
        sb.append("searchBase: '").append(this.searchBase).append("'");
        sb.append(", scope: ").append(this.searchControls.getSearchScope() == 2 ? "subtree" : "single-level, ");
        sb.append(", searchTimeLimit: ").append(this.searchControls.getTimeLimit());
        sb.append(", derefLinkFlag: ").append(this.searchControls.getDerefLinkFlag()).append(" ]");
        return sb.toString();
    }
}

