/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.ssl.SSLSocketConfig;
import java.util.ArrayList;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;

@BridgeMethodsAdded
public class SSLParametersSocketConfig
implements SSLSocketConfig {
    private String[] cipherSuites;
    private String[] serverProtocols;
    private String[] clientProtocols;

    public SSLParametersSocketConfig(String[] cipherSuites, String[] protocols) {
        this.setCipherSuites(cipherSuites);
        this.setProtocols(protocols);
    }

    public void setCipherSuites(String[] cipherSuites) {
        this.cipherSuites = this.clone(cipherSuites);
    }

    public String[] getCipherSuites() {
        return this.clone(this.cipherSuites);
    }

    public void setProtocols(String[] protocols) {
        protocols = this.clone(protocols);
        this.serverProtocols = protocols;
        this.clientProtocols = this.removeSSLv2Hello(protocols);
    }

    public String[] getProtocols() {
        return this.clone(this.serverProtocols);
    }

    private String[] clone(String[] s) {
        return s == null ? null : (String[])s.clone();
    }

    public void configure(SSLSocket socket) {
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.clientProtocols != null && this.clientProtocols.length > 0) {
            socket.setEnabledProtocols(this.clientProtocols);
        }
    }

    public void configure(SSLServerSocket socket) {
        if (this.cipherSuites != null && this.cipherSuites.length > 0) {
            socket.setEnabledCipherSuites(this.cipherSuites);
        }
        if (this.serverProtocols != null && this.serverProtocols.length > 0) {
            socket.setEnabledProtocols(this.serverProtocols);
        }
    }

    private String[] removeSSLv2Hello(String[] protos) {
        if (protos == null) {
            return protos;
        }
        ArrayList<String> list = new ArrayList<String>(protos.length);
        for (String p : protos) {
            if ("SSLv2Hello".equalsIgnoreCase(p)) continue;
            list.add(p);
        }
        if (protos.length == list.size()) {
            return protos;
        }
        return list.toArray(new String[0]);
    }
}

