/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.authentication;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousAuthenticationToken
extends AbstractAuthenticationToken
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Object principal;
    private final int keyHash;

    public AnonymousAuthenticationToken(String key, Object principal, GrantedAuthority[] authorities) {
        this(key, principal, Arrays.asList(authorities));
    }

    public AnonymousAuthenticationToken(String key, Object principal, List<GrantedAuthority> authorities) {
        super(authorities);
        if (key == null || "".equals(key) || principal == null || "".equals(principal) || authorities == null || authorities.isEmpty()) {
            throw new IllegalArgumentException("Cannot pass null or empty values to constructor");
        }
        this.keyHash = key.hashCode();
        this.principal = principal;
        this.setAuthenticated(true);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (obj instanceof AnonymousAuthenticationToken) {
            AnonymousAuthenticationToken test = (AnonymousAuthenticationToken)obj;
            return this.getKeyHash() == test.getKeyHash();
        }
        return false;
    }

    @Override
    public Object getCredentials() {
        return "";
    }

    public int getKeyHash() {
        return this.keyHash;
    }

    @Override
    public Object getPrincipal() {
        return this.principal;
    }
}

