/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.core.session.SessionDestroyedEvent;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionRegistryImpl
implements SessionRegistry,
ApplicationListener<SessionDestroyedEvent> {
    protected final Log logger = LogFactory.getLog(SessionRegistryImpl.class);
    private final Map<Object, Set<String>> principals = Collections.synchronizedMap(new HashMap());
    private final Map<String, SessionInformation> sessionIds = Collections.synchronizedMap(new HashMap());

    @Override
    public List<Object> getAllPrincipals() {
        return Arrays.asList(this.principals.keySet().toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionInformation> getAllSessions(Object principal, boolean includeExpiredSessions) {
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            return Collections.emptyList();
        }
        ArrayList<SessionInformation> list = new ArrayList<SessionInformation>(sessionsUsedByPrincipal.size());
        Set<String> set = sessionsUsedByPrincipal;
        synchronized (set) {
            for (String sessionId : sessionsUsedByPrincipal) {
                SessionInformation sessionInformation = this.getSessionInformation(sessionId);
                if (sessionInformation == null || !includeExpiredSessions && sessionInformation.isExpired()) continue;
                list.add(sessionInformation);
            }
        }
        return list;
    }

    @Override
    public SessionInformation getSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        return this.sessionIds.get(sessionId);
    }

    public void onApplicationEvent(SessionDestroyedEvent event) {
        String sessionId = event.getId();
        this.removeSessionInformation(sessionId);
    }

    @Override
    public void refreshLastRequest(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info != null) {
            info.refreshLastRequest();
        }
    }

    @Override
    public synchronized void registerNewSession(String sessionId, Object principal) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        Assert.notNull((Object)principal, (String)"Principal required as per interface contract");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Registering session " + sessionId + ", for principal " + principal));
        }
        if (this.getSessionInformation(sessionId) != null) {
            this.removeSessionInformation(sessionId);
        }
        this.sessionIds.put(sessionId, new SessionInformation(principal, sessionId, new Date()));
        Set<String> sessionsUsedByPrincipal = this.principals.get(principal);
        if (sessionsUsedByPrincipal == null) {
            sessionsUsedByPrincipal = Collections.synchronizedSet(new HashSet(4));
            this.principals.put(principal, sessionsUsedByPrincipal);
        }
        sessionsUsedByPrincipal.add(sessionId);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sessions used by '" + principal + "' : " + sessionsUsedByPrincipal));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessionInformation(String sessionId) {
        Assert.hasText((String)sessionId, (String)"SessionId required as per interface contract");
        SessionInformation info = this.getSessionInformation(sessionId);
        if (info == null) {
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.debug((Object)("Removing session " + sessionId + " from set of registered sessions"));
        }
        this.sessionIds.remove(sessionId);
        Set<String> sessionsUsedByPrincipal = this.principals.get(info.getPrincipal());
        if (sessionsUsedByPrincipal == null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Removing session " + sessionId + " from principal's set of registered sessions"));
        }
        Set<String> set = sessionsUsedByPrincipal;
        synchronized (set) {
            sessionsUsedByPrincipal.remove(sessionId);
            if (sessionsUsedByPrincipal.size() == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Removing principal " + info.getPrincipal() + " from registry"));
                }
                this.principals.remove(info.getPrincipal());
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Sessions used by '" + info.getPrincipal() + "' : " + sessionsUsedByPrincipal));
        }
    }
}

