/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.ds.client;

import com.urbancode.ds.client.ClientCommandFlag;
import com.urbancode.ds.client.ClientCommandOption;
import com.urbancode.ds.client.ClientConfiguration;
import com.urbancode.ds.client.MissingRequiredParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedCommandLine {
    private String cmdName;
    private String fileName;
    private boolean readFromInputStream;
    private Map<String, Set<String>> optMap = new HashMap<String, Set<String>>();
    private Map<String, String> envMap = new HashMap<String, String>();
    private List<String> flagList = new ArrayList<String>();

    public ParsedCommandLine(String cmdName, String fileName, boolean readFromInputStream, Map<String, Set<String>> optMap, Map<String, String> envMap, List<String> flagList) {
        this.cmdName = cmdName;
        this.fileName = fileName;
        this.readFromInputStream = readFromInputStream;
        if (optMap != null) {
            this.optMap.putAll(optMap);
        }
        if (envMap != null) {
            this.envMap.putAll(envMap);
        }
        if (flagList != null) {
            this.flagList.addAll(flagList);
        }
    }

    String getCommandName() {
        return this.cmdName;
    }

    String getFileName() {
        return this.fileName;
    }

    boolean isReadFromInputStream() {
        return this.readFromInputStream;
    }

    String getOptionValue(String name, boolean required) throws MissingRequiredParameterException {
        return this.first(this.getOptionValues(name, null, null, null, required));
    }

    String getOptionValue(ClientCommandOption option) throws MissingRequiredParameterException {
        return this.first(this.getOptionValues(option));
    }

    String getOptionValue(String name, String shortName, String envName, String defaultValue, boolean required) throws MissingRequiredParameterException {
        return this.first(this.getOptionValues(name, shortName, envName, defaultValue, required));
    }

    Set<String> getOptionValues(String name, boolean required) throws MissingRequiredParameterException {
        return this.getOptionValues(name, null, null, null, required);
    }

    Set<String> getOptionValues(String name, String shortName, String envName, String defaultValue, boolean required) throws MissingRequiredParameterException {
        String tempVal;
        Set<String> value = this.optMap.get(name);
        if (value == null && shortName != null) {
            value = this.optMap.get(shortName);
        }
        if (value == null && envName != null && (tempVal = this.envMap.get(envName)) != null) {
            value = Collections.singleton(tempVal);
        }
        if (value == null && defaultValue != null) {
            value = Collections.singleton(defaultValue);
        }
        if (value == null && required) {
            throw MissingRequiredParameterException.newException(name, envName);
        }
        return value;
    }

    Set<String> getOptionValues(ClientCommandOption option) throws MissingRequiredParameterException {
        String optionName = option.getName();
        String optionShort = option.getShortName();
        String optionEnvName = option.getEnvName();
        String optionDefaultValue = option.getDefaultValue();
        boolean optionRequired = option.isRequired();
        return this.getOptionValues(optionName, optionShort, optionEnvName, optionDefaultValue, optionRequired);
    }

    public void setOptionValue(String name, String value) {
        if (StringUtils.isEmpty(value)) {
            this.optMap.remove(name);
        } else {
            this.optMap.put(name, Collections.singleton(value));
        }
    }

    boolean isFlagSet(ClientCommandFlag flag) {
        boolean result = false;
        for (String setFlag : this.flagList) {
            if (!setFlag.equals(flag.getShortName()) && !setFlag.equals(flag.getName())) continue;
            result = true;
        }
        return result;
    }

    boolean isPrintHelpAndExit() {
        boolean result = false;
        try {
            if (this.isFlagSet(ClientConfiguration.FLAG_HELP)) {
                result = true;
            } else if (this.getCommandName() == null) {
                result = true;
            }
        }
        catch (Exception e) {
            result = true;
        }
        return result;
    }

    private <T> T first(Collection<T> collection) {
        return collection == null || collection.isEmpty() ? null : (T)collection.iterator().next();
    }
}

