/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import javax.naming.Name;
import javax.naming.directory.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.transaction.compensating.CompensatingTransactionOperationExecutor;

public class BindOperationExecutor
implements CompensatingTransactionOperationExecutor {
    private static Log log = LogFactory.getLog((Class)BindOperationExecutor.class);
    private LdapOperations ldapOperations;
    private Name dn;
    private Object originalObject;
    private Attributes originalAttributes;

    public BindOperationExecutor(LdapOperations ldapOperations, Name dn, Object originalObject, Attributes originalAttributes) {
        this.ldapOperations = ldapOperations;
        this.dn = dn;
        this.originalObject = originalObject;
        this.originalAttributes = originalAttributes;
    }

    public void rollback() {
        try {
            this.ldapOperations.unbind(this.dn);
        }
        catch (Exception e) {
            log.warn((Object)("Failed to rollback, dn:" + this.dn.toString()), (Throwable)e);
        }
    }

    public void commit() {
        log.debug((Object)"Nothing to do in commit for bind operation");
    }

    public void performOperation() {
        log.debug((Object)"Performing bind operation");
        this.ldapOperations.bind(this.dn, this.originalObject, this.originalAttributes);
    }

    Name getDn() {
        return this.dn;
    }

    LdapOperations getLdapOperations() {
        return this.ldapOperations;
    }

    Attributes getOriginalAttributes() {
        return this.originalAttributes;
    }

    Object getOriginalObject() {
        return this.originalObject;
    }
}

