/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.taglibs.authz;

import java.io.IOException;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.security.access.expression.ExpressionUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.taglibs.authz.LegacyAuthorizeTag;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.WebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.expression.WebSecurityExpressionHandler;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class AuthorizeTag
extends LegacyAuthorizeTag {
    private String access;
    private String url;
    private String method;
    private static final FilterChain DUMMY_CHAIN = new FilterChain(){

        public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            throw new UnsupportedOperationException();
        }
    };

    public int doStartTag() throws JspException {
        Authentication currentUser = SecurityContextHolder.getContext().getAuthentication();
        if (currentUser == null) {
            return 0;
        }
        if (this.access != null && this.access.length() > 0) {
            return this.authorizeUsingAccessExpression(currentUser);
        }
        if (this.url != null && this.url.length() > 0) {
            return this.authorizeUsingUrlCheck(currentUser);
        }
        return super.doStartTag();
    }

    private int authorizeUsingAccessExpression(Authentication currentUser) throws JspException {
        Expression accessExpression;
        WebSecurityExpressionHandler handler = this.getExpressionHandler();
        try {
            accessExpression = handler.getExpressionParser().parseExpression(this.access);
        }
        catch (ParseException e) {
            throw new JspException((Throwable)e);
        }
        FilterInvocation f = new FilterInvocation(this.pageContext.getRequest(), this.pageContext.getResponse(), DUMMY_CHAIN);
        if (ExpressionUtils.evaluateAsBoolean((Expression)accessExpression, (EvaluationContext)handler.createEvaluationContext(currentUser, f))) {
            return 1;
        }
        return 0;
    }

    private int authorizeUsingUrlCheck(Authentication currentUser) throws JspException {
        return this.getPrivilegeEvaluator().isAllowed(((HttpServletRequest)this.pageContext.getRequest()).getContextPath(), this.url, this.method, currentUser) ? 1 : 0;
    }

    public void setAccess(String access) {
        this.access = access;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    WebSecurityExpressionHandler getExpressionHandler() throws JspException {
        ServletContext servletContext = this.pageContext.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Map expressionHdlrs = ctx.getBeansOfType(WebSecurityExpressionHandler.class);
        if (expressionHdlrs.size() == 0) {
            throw new JspException("No visible WebSecurityExpressionHandler instance could be found in the application context. There must be at least one in order to support expressions in JSP 'authorize' tags.");
        }
        return (WebSecurityExpressionHandler)expressionHdlrs.values().toArray()[0];
    }

    WebInvocationPrivilegeEvaluator getPrivilegeEvaluator() throws JspException {
        ServletContext servletContext = this.pageContext.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
        Map wipes = ctx.getBeansOfType(WebInvocationPrivilegeEvaluator.class);
        if (wipes.size() == 0) {
            throw new JspException("No visible WebInvocationPrivilegeEvaluator instance could be found in the application context. There must be at least one in order to support the use of URL access checks in 'authorize' tags.");
        }
        return (WebInvocationPrivilegeEvaluator)wipes.values().toArray()[0];
    }
}

