/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.ui.CommonUIPlugin;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditUIMarkerHelper
extends MarkerHelper {
    protected IFile getFile(Object datum) {
        String location;
        if (datum instanceof Resource) {
            Resource resource = (Resource)datum;
            URI uri = resource.getURI();
            if (uri == null) {
                return null;
            }
            ResourceSet resourceSet = resource.getResourceSet();
            if (resourceSet != null) {
                uri = resourceSet.getURIConverter().normalize(uri);
            }
            return this.getFile(uri);
        }
        if (datum instanceof EObject) {
            return this.getFile(((EObject)datum).eResource());
        }
        if (datum instanceof Resource.Diagnostic && (location = ((Resource.Diagnostic)datum).getLocation()) != null) {
            return this.getFile(URI.createURI((String)location));
        }
        return super.getFile(datum);
    }

    protected void adjustMarker(IMarker marker, Diagnostic diagnostic, Diagnostic parentDiagnostic) throws CoreException {
        if (!this.adjustMarker(marker, diagnostic) && parentDiagnostic != null) {
            this.adjustMarker(marker, parentDiagnostic);
        }
    }

    protected boolean adjustMarker(IMarker marker, Diagnostic diagnostic) throws CoreException {
        if (diagnostic.getData() != null) {
            for (Object element : diagnostic.getData()) {
                Resource.Diagnostic resourceDiagnostic;
                if (!(element instanceof Resource.Diagnostic) || (resourceDiagnostic = (Resource.Diagnostic)element).getLocation() == null) continue;
                marker.setAttribute("location", (Object)EMFEditUIPlugin.getPlugin().getString("_UI_MarkerLocation", new String[]{Integer.toString(resourceDiagnostic.getLine()), Integer.toString(resourceDiagnostic.getColumn())}));
                marker.setAttribute("lineNumber", resourceDiagnostic.getLine());
                return true;
            }
        }
        return false;
    }

    public boolean hasMarkers(Object object, boolean includeSubtypes, int depth) {
        List data;
        if (object instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)object;
            EList resources = resourceSet.getResources();
            int i = 0;
            int size = resources.size();
            while (i < size) {
                if (this.hasMarkers(resources.get(i), includeSubtypes, depth)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (object instanceof Diagnostic && (data = ((Diagnostic)object).getData()) != null) {
            for (Object datum : data) {
                if (!(datum instanceof ResourceSet)) continue;
                return this.hasMarkers(datum, includeSubtypes, depth);
            }
        }
        return super.hasMarkers(object, includeSubtypes, depth);
    }

    public void deleteMarkers(Object object, boolean includeSubtypes, int depth) {
        List data;
        if (object instanceof ResourceSet) {
            ResourceSet resourceSet = (ResourceSet)object;
            EList resources = resourceSet.getResources();
            int i = 0;
            int size = resources.size();
            while (i < size) {
                this.deleteMarkers(resources.get(i), includeSubtypes, depth);
                ++i;
            }
        } else if (object instanceof Diagnostic && (data = ((Diagnostic)object).getData()) != null) {
            for (Object datum : data) {
                if (!(datum instanceof ResourceSet)) continue;
                this.deleteMarkers(datum, includeSubtypes, depth);
                return;
            }
        }
        super.deleteMarkers(object, includeSubtypes, depth);
    }

    public List<?> getTargetObjects(Object object, IMarker marker, boolean wrap) {
        if (object instanceof AdapterFactoryEditingDomain) {
            String relatedURIsAttribute;
            ArrayList<EObject> result = new ArrayList<EObject>();
            AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)object;
            String uriAttribute = marker.getAttribute("uri", null);
            if (uriAttribute == null) {
                uriAttribute = marker.getAttribute("URI_KEY", null);
            }
            if (uriAttribute != null) {
                URI uri = URI.createURI((String)uriAttribute);
                try {
                    EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
                    if (eObject != null) {
                        result.add((EObject)(wrap ? editingDomain.getWrapper((Object)eObject) : eObject));
                    }
                }
                catch (Throwable eObject) {
                    // empty catch block
                }
            }
            if ((relatedURIsAttribute = marker.getAttribute("relatedURIs", null)) != null) {
                String[] stringArray = relatedURIsAttribute.split(" ");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String relatedURI = stringArray[n2];
                    URI uri = URI.createURI((String)URI.decode((String)relatedURI));
                    try {
                        EObject eObject = editingDomain.getResourceSet().getEObject(uri, true);
                        if (eObject != null) {
                            result.add((EObject)(wrap ? editingDomain.getWrapper((Object)eObject) : eObject));
                        }
                    }
                    catch (Throwable eObject) {
                        // empty catch block
                    }
                    ++n2;
                }
            } else {
                relatedURIsAttribute = marker.getAttribute("DATA_KEY", null);
                if (relatedURIsAttribute != null) {
                    int start = 0;
                    int length = relatedURIsAttribute.length();
                    int index = relatedURIsAttribute.indexOf(58);
                    while (start < length) {
                        int itemLength = Integer.parseInt(relatedURIsAttribute.substring(start, index == -1 ? length : index));
                        start = index + itemLength + 1;
                        String uriLiteral = relatedURIsAttribute.substring(index + 1, start);
                        try {
                            EObject eObject;
                            URI uri = URI.createURI((String)uriLiteral);
                            if (uri.hasFragment() && (eObject = editingDomain.getResourceSet().getEObject(uri, true)) != null) {
                                result.add((EObject)(wrap ? editingDomain.getWrapper((Object)eObject) : eObject));
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        index = relatedURIsAttribute.indexOf(58, start);
                    }
                }
            }
            return result;
        }
        return super.getTargetObjects(object, marker, wrap);
    }

    public Diagnostic getMarkerDiagnostics(Object object, IFile file, boolean wrap) {
        if (file == null) {
            file = this.getFile(object);
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)resource.getResourceSet());
            BasicDiagnostic diagnostic = new BasicDiagnostic(this.getDiagnosticSource(), 0, null, new Object[]{resource});
            if (file != null && file.isAccessible()) {
                try {
                    IMarker[] iMarkerArray = file.findMarkers(null, true, 0);
                    int n = iMarkerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        List<?> data;
                        IMarker marker = iMarkerArray[n2];
                        String message = marker.getAttribute("message", "");
                        int severity = marker.getAttribute("severity", 0);
                        String sourceID = marker.getAttribute("sourceId", "");
                        List<?> list = data = wrap ? this.getTargetObjects(editingDomain, marker) : this.getTargetObjects(editingDomain, marker, false);
                        diagnostic.add((Diagnostic)new BasicDiagnostic(severity == 2 ? 4 : (severity == 1 ? 2 : 1), sourceID, 0, message, data.toArray(new Object[data.size()])));
                        ++n2;
                    }
                }
                catch (CoreException exception) {
                    CommonUIPlugin.INSTANCE.log((Object)exception);
                }
            }
            for (Resource.Diagnostic resourceDiagnostic : resource.getWarnings()) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(2, null, 0, resourceDiagnostic.getMessage(), new Object[]{resource}));
            }
            for (Resource.Diagnostic resourceDiagnostic : resource.getErrors()) {
                diagnostic.add((Diagnostic)new BasicDiagnostic(4, null, 0, resourceDiagnostic.getMessage(), new Object[]{resource}));
            }
            return diagnostic;
        }
        return super.getMarkerDiagnostics(object, file, wrap);
    }
}

