/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname    = inProps['hostname'].trim()
String port        = inProps['port'].trim()
String username    = inProps['username']
String password    = inProps['password']
String execServer  = inProps['execServer'].trim()
String file        = inProps['file'].trim()
String merging     = inProps['merging']
String versioning  = inProps['versioning']
boolean failOnError = inProps['failOnError'].toBoolean()

// import .jar files
File execDir = new File(execServer)
if (!execDir.isDirectory()) {
    println ("[error]  Directory ${execDir.getAbsolutePath()} does not exist.")
    println ('[possible solution]  Please update the step configuration with a valid value for Execution Server.')
    System.exit(1)
}
File engineJar = new File(execServer + File.separator + 'lib' + File.separator + 'jrules-engine.jar')
File toolsJar = new File(execServer + File.separator + 'lib' + File.separator + 'jrules-res-tools.jar')
if (!engineJar.isFile()) {
    println ("[error]  File ${engineJar.getAbsolutePath()} does not exist.")
    println ('[possible solution]  Please check that the file exists on your ODM serverin the above location.')
    System.exit(1)
}
if (!toolsJar.isFile()) {
    println ("[error]  File ${toolsJar.getAbsolutePath()} does not exist.")
    println ('[possible solution]  Please check that the file exists on your ODM server in the above location.')
    System.exit(1)
}
this.getClass().classLoader.rootLoader.addURL(engineJar.toURL())
this.getClass().classLoader.rootLoader.addURL(toolsJar.toURL())

// Set up ant arguments
def ant = new AntBuilder()
ant.taskdef(name:'ilrDeployRuleAppTask', classname:'ilog.rules.res.tools.http.IlrDeployRuleAppTask')

ant.ilrDeployRuleAppTask(
    hostname: hostname,
    portnumber: port,
    userid: username,
    password: password,
    file: file,
    mergingpolicy: merging,
    versioningpolicy: versioning,
    failonerror: failOnError
)
