/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2017. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname = inProps['hostname'].trim()
String port     = inProps['port'].trim()
String username = inProps['username'].trim()
String password = inProps['password']

String resource = inProps['resource'].trim()

final def workDir = new File('.').canonicalFile
OdmHelper oh = new OdmHelper(username, password)
String[] resourceArray = resource.split('/')

String path = "res/api/v1/xoms/${resource}"
//If no version specified, get highest
if (resourceArray.size() == 1) {
    String highestVersionPath = path + "/highest"
    if (!oh.setUri(hostname, port, highestVersionPath)) {
        println ('[Error] Could not set URI.')
        System.exit(1)
    }
    def versionNumber = oh.getHighestVersion()
    if (versionNumber){
        path += "/${versionNumber}"

    }
    else {
        println ("[Error] Not able to determine highest version for resource: ${resource}")
        println ('[Possible Solution] Please update resource with a valid value and proper formatting')
        System.exit(1)
    }
}
// Size of resource should not be larger than 2 for fetching xom
else if (resourceArray.size() > 2) {
    println ('[Error] Resource format invalid.')
    println ('[Possible Solution] Please update the step configuration with a valid resource definition supplied in the ' +
             'Resource property description.')
    System.exit(1)
}

String archivePath = path + "/bytecode"
String downloadName = "${resourceArray[0]}"
if (!oh.setUri(hostname, port, archivePath)) {
    println ('[Error] Could not set URI.')
    System.exit(1)
}
println ('[Action] Fetching Resource...')
def deployed = oh.fetchResource(workDir, downloadName)
if (deployed) {
    println ("[Ok] Resource fetched.")
    System.exit(0)
}
else {
    println ('[Error] Could not fetch resource.')
    System.exit(1)
}
