/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

def separator = '\n|[\n]|\r\n|[\r\n]'
String hostname = inProps['hostname'].trim()
String port     = inProps['port'].trim()
String username = inProps['username']
String password = inProps['password']

def decisionServiceName = inProps['decisionServiceName'].trim()
def unparsedTestSuiteNames = inProps['testSuiteNames']
unparsedTestSuiteNames = unparsedTestSuiteNames.replaceAll(separator, ",")
def testSuiteNames = unparsedTestSuiteNames.split(',')*.trim()

OdmHelper oh = new OdmHelper(username, password)
if (!oh.setUri(hostname, port, "decisioncenter-api/v1/decisionservices?q=name:"+decisionServiceName)) {
    println ('[error]  Could not set URI.')
    System.exit(1)
}
println ('[Action] Running test suites...')
boolean allTestsPassed = oh.runTestSuites(decisionServiceName, testSuiteNames)

if (allTestsPassed) {
    println ("[Ok] Test suites ran successfully.")
    System.exit(0)
}
else {
    println ('[Error] Test suites failed.')
    System.exit(1)
}
