/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname = inProps['hostname'].trim()
String port     = inProps['port'].trim()
String username = inProps['username']
String password = inProps['password']

String file = inProps['file'].trim()
String name = inProps['name'].trim()

OdmHelper oh = new OdmHelper(username, password)
if (!oh.setUrl(hostname, port, "res/api/v1/xoms/${name}")) {
    println ('[error]  Could not set URL.')
    System.exit(1)
}
println ('[action]  Deploying XOM resource...')
def deployed = oh.deployXom(file)
if (deployed) {
    println ("[ok]  XOM Resource deployed.")
    System.exit(0)
}
else {
    println ('[error]  Could not deploy XOM Resource.')
    System.exit(1)
}

