/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname = inProps['hostname'].trim()
String port     = inProps['port'].trim()
String username = inProps['username']
String password = inProps['password']

String file           = inProps['file'].trim()
String ruleAppName    = inProps['ruleAppName'].trim()
String ruleAppVersion = inProps['ruleAppVersion'].trim()
String ruleSetName    = inProps['ruleSetName'].trim()
String ruleSetVersion = inProps['ruleSetVersion'].trim()

OdmHelper oh = new OdmHelper(username, password)
if (!oh.setUri(hostname, port, "res/api/v1/ruleapps/${ruleAppName}/${ruleAppVersion}/${ruleSetName}/${ruleSetVersion}")) {
    println ('[Error] Could not set URI.')
    System.exit(1)
}
println ('[Action] Deploying RuleApp archive...')
def deployed = oh.deployFile(file, "RuleApp Archive", "RuleApp archive")
if (deployed) {
    println ("[Ok] RuleApp Archive deployed.")
    System.exit(0)
}
else {
    println ('[Error] Could not deploy RuleApp Archive.')
    System.exit(1)
}