/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.dbprofiler;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.dbprofiler.DbProfileCounter;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

@BridgeMethodsAdded
class ProfilingPreparedStatement
implements PreparedStatement {
    private final PreparedStatement delegate;

    ProfilingPreparedStatement(PreparedStatement delegate) {
        this.delegate = Check.nonNull(delegate, "delegate");
    }

    public void addBatch() throws SQLException {
        this.delegate.addBatch();
    }

    public void addBatch(String sql) throws SQLException {
        this.delegate.addBatch(sql);
    }

    public void cancel() throws SQLException {
        this.delegate.cancel();
    }

    public void clearBatch() throws SQLException {
        this.delegate.clearBatch();
    }

    public void clearParameters() throws SQLException {
        this.delegate.clearParameters();
    }

    public void clearWarnings() throws SQLException {
        this.delegate.clearWarnings();
    }

    public void close() throws SQLException {
        this.delegate.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute();
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, autoGeneratedKeys);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, columnIndexes);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql, columnNames);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        boolean result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.execute(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException {
        int[] result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeBatch();
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery() throws SQLException {
        ResultSet result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeQuery();
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet executeQuery(String sql) throws SQLException {
        ResultSet result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeQuery(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate() throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate();
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, autoGeneratedKeys);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, columnIndexes);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql, columnNames);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        int result;
        DbProfileCounter counter = this.startExecute();
        try {
            result = this.delegate.executeUpdate(sql);
        }
        finally {
            counter.endExecute();
        }
        return result;
    }

    public Connection getConnection() throws SQLException {
        return this.delegate.getConnection();
    }

    public int getFetchDirection() throws SQLException {
        return this.delegate.getFetchDirection();
    }

    public int getFetchSize() throws SQLException {
        return this.delegate.getFetchSize();
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this.delegate.getGeneratedKeys();
    }

    public int getMaxFieldSize() throws SQLException {
        return this.delegate.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.delegate.getMaxRows();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.delegate.getMetaData();
    }

    public boolean getMoreResults() throws SQLException {
        return this.delegate.getMoreResults();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this.delegate.getMoreResults(current);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.delegate.getParameterMetaData();
    }

    public int getQueryTimeout() throws SQLException {
        return this.delegate.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.delegate.getResultSet();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.delegate.getResultSetConcurrency();
    }

    public int getResultSetHoldability() throws SQLException {
        return this.delegate.getResultSetHoldability();
    }

    public int getResultSetType() throws SQLException {
        return this.delegate.getResultSetType();
    }

    public int getUpdateCount() throws SQLException {
        return this.delegate.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.delegate.getWarnings();
    }

    public void setArray(int i, Array x) throws SQLException {
        this.delegate.setArray(i, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.delegate.setAsciiStream(parameterIndex, x, length);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.delegate.setBigDecimal(parameterIndex, x);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.delegate.setBinaryStream(parameterIndex, x, length);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this.delegate.setBlob(i, x);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.delegate.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.delegate.setByte(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.delegate.setBytes(parameterIndex, x);
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.delegate.setCharacterStream(parameterIndex, reader, length);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this.delegate.setClob(i, x);
    }

    public void setCursorName(String name) throws SQLException {
        this.delegate.setCursorName(name);
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.delegate.setDate(parameterIndex, x, cal);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.delegate.setDate(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.delegate.setDouble(parameterIndex, x);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.delegate.setEscapeProcessing(enable);
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.delegate.setFetchDirection(direction);
    }

    public void setFetchSize(int rows) throws SQLException {
        this.delegate.setFetchSize(rows);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.delegate.setFloat(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.delegate.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.delegate.setLong(parameterIndex, x);
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.delegate.setMaxFieldSize(max);
    }

    public void setMaxRows(int max) throws SQLException {
        this.delegate.setMaxRows(max);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.delegate.setNull(paramIndex, sqlType, typeName);
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.delegate.setNull(parameterIndex, sqlType);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this.delegate.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.delegate.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.delegate.setObject(parameterIndex, x);
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this.delegate.setQueryTimeout(seconds);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this.delegate.setRef(i, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.delegate.setShort(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this.delegate.setString(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.delegate.setTime(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.delegate.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.delegate.setTimestamp(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.delegate.setTimestamp(parameterIndex, x);
    }

    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.delegate.setUnicodeStream(parameterIndex, x, length);
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.delegate.setURL(parameterIndex, x);
    }

    private DbProfileCounter startExecute() {
        DbProfileCounter result = DbProfileCounter.getCounter();
        result.startExecute();
        return result;
    }
}

