/*
 * Licensed Materials - Property of IBM Corp.
 * IBM UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname = inProps['hostname'].trim()
String port     = inProps['port'].trim()
String username = inProps['username']
String password = inProps['password']

String resource  = inProps['resource'].trim()
boolean addNew   = Boolean.valueOf(inProps['addNew'])
String propName  = inProps['propName'].trim()
String propValue = inProps['propValue'].trim()

while (hostname.endsWith('/')) {
    hostname = hostname.substring(0, hostname.length() - 1)
}

OdmHelper oh = new OdmHelper(username, password)
String uri = "res/api/v1/ruleapps/" + resource + "/properties/" + propName

println ("[Action] Setting property ${propName}...")
if (!oh.setUri(hostname, port, uri)) {
    println ('[Error] Could not set URI.')
    System.exit(1)
}

def updated = oh.setProperty(propName, propValue, addNew)

if (updated) {
    println ("[Ok] Property '${propName}' set to '${propValue}'")
}
else {
    println ("[Error] Could not update property ${propName}")
    System.exit(1)
}