/*
 * Licensed Materials - Property of IBM* and/or HCL**
 * UrbanCode Deploy
 * (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
 * (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
 *
 * U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
 * GSA ADP Schedule Contract with IBM Corp.
 *
 * * Trademark of International Business Machines
 * ** Trademark of HCL Technologies Limited
 */

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

def separator = '\n|[\n]|\r\n|[\r\n]'
String hostname = (inProps['hostname']!=null && inProps['hostname'].length()>0) ? inProps['hostname'].trim() : inProps['hostname']
String port     = inProps['port']
String username = (inProps['username']!=null && inProps['username'].length()>0) ? inProps['username'].trim() : inProps['username']
String password = inProps['password']

String tokenUrl = inProps['tokenUrl']
String scope = (inProps['scope']!=null && inProps['scope'].length()>0) ? inProps['scope'].trim() : inProps['scope']
String grantType = (inProps['grantType']!=null && inProps['grantType'].length()>0) ? inProps['grantType'].trim() : inProps['grantType']
String clientID = inProps['clientID']
String clientSecret = inProps['clientSecret']
String oAuthusername = inProps['oAuthusername']
String oAuthpassword = inProps['oAuthpassword']

def decisionServiceName = inProps['decisionServiceName']
def unparsedTestSuiteNames = inProps['testSuiteNames']
unparsedTestSuiteNames = unparsedTestSuiteNames.replaceAll(separator, ",")
def testSuiteNames = unparsedTestSuiteNames.split(',')*.trim()

OdmHelper oh = new OdmHelper(username, password, tokenUrl, scope, grantType, clientID, clientSecret, oAuthusername, oAuthpassword)
if (!oh.setUri(hostname, port, "decisioncenter-api/v1/decisionservices?q=name:"+decisionServiceName)) {
    println ('[error]  Could not set URI.')
    System.exit(1)
}
println ('[Action] Running test suites...')
boolean allTestsPassed = oh.runTestSuites(decisionServiceName, testSuiteNames)

if (allTestsPassed) {
    println ("[Ok] Test suites ran successfully.")
    System.exit(0)
}
else {
    println ('[Error] Test suites failed.')
    System.exit(1)
}
