/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2016, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.odm.OdmHelper

// Get step properties
def apTool  = new AirPluginTool(args[0], args[1])
def inProps = apTool.getStepProperties()

String hostname = (inProps['hostname']!=null && inProps['hostname'].length()>0) ? inProps['hostname'].trim() : inProps['hostname']
String port     = inProps['port']
String username = inProps['username']
String password = inProps['password']

String file = inProps['file']
String name = inProps['name']

String tokenUrl = inProps['tokenUrl']
String scope = (inProps['scope']!=null && inProps['scope'].length()>0) ? inProps['scope'].trim() : inProps['scope']
String grantType = (inProps['grantType']!=null && inProps['grantType'].length()>0) ? inProps['grantType'].trim() : inProps['grantType']
String clientID = inProps['clientID']
String clientSecret = inProps['clientSecret']
String oAuthusername = inProps['oAuthusername']
String oAuthpassword = inProps['oAuthpassword']


OdmHelper oh = new OdmHelper(username, password, tokenUrl, scope, grantType, clientID, clientSecret, oAuthusername, oAuthpassword)
if (!oh.setUri(hostname, port, "res/api/v1/xoms/${name}")) {
    println ('[error]  Could not set URI.')
    System.exit(1)
}
println ('[Action] Deploying XOM resource...')
def deployed = oh.deployFile(file, "XOM File", "XOM resource")
if (deployed) {
    println ("[Ok] XOM Resource deployed.")
    System.exit(0)
}
else {
    println ('[Error] Could not deploy XOM Resource.')
    System.exit(1)
}