/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell;

import java.util.Comparator;

public class EnvVar {
    public static final Comparator<EnvVar> CASE_INSENSITIVE_ORDER = new Comparator<EnvVar>(){

        @Override
        public int compare(EnvVar v1, EnvVar v2) {
            return String.CASE_INSENSITIVE_ORDER.compare(v1.name, v2.name);
        }
    };
    private String name = null;
    private String value = null;
    private boolean secure = false;

    public EnvVar(String name, String value) {
        this(name, value, false);
    }

    public EnvVar(String name, String value, boolean secure) {
        if (name == null) {
            throw new IllegalArgumentException("EnvVar.name is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("EnvVar.value is null");
        }
        this.name = name;
        this.value = value;
        this.secure = secure;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    protected void setValue(String value) {
        this.value = value;
    }

    public boolean isSecure() {
        return this.secure;
    }

    protected void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getDisplayValue() {
        if (this.secure) {
            return "*****";
        }
        return this.value;
    }

    public String toString() {
        return this.name + "=" + this.getDisplayValue();
    }

    public EnvVar copy() {
        return new EnvVar(this.name, this.value, this.secure);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        EnvVar envVar = (EnvVar)obj;
        return this.name == envVar.getName() || this.name != null && this.name.equals(envVar.getName());
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }
}

