/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.shell.impersonation.unix;

import com.urbancode.commons.util.IO;
import com.urbancode.commons.util.unix.Unix;
import com.urbancode.commons.util.unix.UnixCommandUnavailableException;
import com.urbancode.shell.impersonation.unix.SuScriptTemplateNotFound;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SuScriptGenerator {
    private static final Logger log = Logger.getLogger(SuScriptGenerator.class);
    private static final String SU_SCRIPT = System.getProperty("com.urbancode.shell.suScript", "com/urbancode/shell/impersonation/unix/su-script");
    private static final String SH = "@SH@";
    private static final String RM = "@RM@";
    private static final String VARIABLES = "@VARIABLES@";
    private static final String COMMAND = "@COMMAND@";
    private static final String WORKDIR = "@WORKDIR@";
    private final List<String> commandLine;
    private final Map<String, String> environment;
    private final File workDir;
    private final Unix unix;
    private final Charset charset;

    private static List<String> mapEscapeSh(Collection<String> coll) {
        ArrayList<String> result = new ArrayList<String>();
        for (String a : coll) {
            result.add(Unix.escapeSh((String)a));
        }
        return result;
    }

    private static String newAssignmentStatement(Map.Entry<String, String> entry) {
        return entry.getKey() + "=" + Unix.escapeSh((String)entry.getValue());
    }

    private static String newExportStatement(Map.Entry<String, String> entry) {
        return "export " + entry.getKey();
    }

    private static String join(Collection<? extends CharSequence> strings, CharSequence separator) {
        StringBuilder builder = new StringBuilder();
        if (separator == null) {
            for (CharSequence charSequence : strings) {
                builder.append(charSequence);
            }
        } else {
            Iterator<? extends CharSequence> i = strings.iterator();
            if (i.hasNext()) {
                builder.append(i.next());
            }
            while (i.hasNext()) {
                builder.append(separator);
                builder.append(i.next());
            }
        }
        return builder.toString();
    }

    private static String read(InputStream stream, Charset charset) throws IOException {
        int count;
        InputStreamReader reader = new InputStreamReader(stream, charset);
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[512];
        while ((count = reader.read(buffer)) != -1) {
            builder.append(buffer, 0, count);
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(File file, String str, Charset charset) throws IOException {
        OutputStreamWriter writer;
        FileOutputStream out = new FileOutputStream(file);
        boolean ok = false;
        try {
            writer = new OutputStreamWriter((OutputStream)out, charset);
            ok = true;
        }
        finally {
            if (!ok) {
                try {
                    out.close();
                }
                catch (IOException swallow) {}
            }
        }
        try {
            writer.write(str);
        }
        finally {
            ((Writer)writer).close();
        }
    }

    public SuScriptGenerator(Unix unix, List<String> commandLine, Map<String, String> environment, File workDir) {
        this(unix, commandLine, environment, workDir, IO.utf8());
    }

    public SuScriptGenerator(Unix unix, List<String> commandLine, Map<String, String> environment, File workDir, Charset charset) {
        if (unix == null) {
            throw new NullPointerException("unix");
        }
        if (commandLine == null) {
            throw new NullPointerException("commandLine");
        }
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        if (workDir == null) {
            throw new NullPointerException("workDir");
        }
        this.unix = unix;
        this.commandLine = new ArrayList<String>(commandLine);
        this.environment = new HashMap<String, String>(environment);
        this.workDir = workDir;
        this.charset = charset;
    }

    public void writeTo(File file) throws IOException {
        String template = this.readTemplate();
        String script = this.populateTemplate(template);
        SuScriptGenerator.write(file, script, this.charset);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Wrote su script to " + file));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Su script content:\n" + script + this.eol(script) + "End script."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readTemplate() throws IOException {
        String template;
        InputStream in = this.openTemplate();
        try {
            template = SuScriptGenerator.read(in, IO.utf8());
        }
        finally {
            in.close();
        }
        return template;
    }

    private String populateTemplate(String template) throws UnixCommandUnavailableException {
        String command = this.getCommandString();
        String variables = this.getVariablesString();
        String workDir = this.getWorkDirString();
        template = template.replace(RM, this.unix.rmPath());
        template = template.replace(SH, this.unix.shPath());
        template = template.replace(COMMAND, command);
        template = template.replace(VARIABLES, variables);
        template = template.replace(WORKDIR, workDir);
        template = this.fixLineEndings(template);
        return template;
    }

    private InputStream openTemplate() throws SuScriptTemplateNotFound {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream in = loader.getResourceAsStream(SU_SCRIPT);
        if (in == null) {
            throw new SuScriptTemplateNotFound(SU_SCRIPT);
        }
        return in;
    }

    private String fixLineEndings(String template) {
        return template.replace("\r", "");
    }

    private String getCommandString() {
        return SuScriptGenerator.join(SuScriptGenerator.mapEscapeSh(this.commandLine), " ");
    }

    private String getVariablesString() {
        String result = "";
        if (this.environment != null) {
            ArrayList<String> strings = new ArrayList<String>();
            for (Map.Entry<String, String> v : this.environment.entrySet()) {
                String key = v.getKey();
                String val = v.getValue();
                if (key != null && key.endsWith("()") || val != null && val.startsWith("()")) continue;
                strings.add(SuScriptGenerator.newAssignmentStatement(v));
                strings.add(SuScriptGenerator.newExportStatement(v));
            }
            result = SuScriptGenerator.join(strings, "\n");
        }
        return result;
    }

    private String getWorkDirString() {
        if (this.workDir == null) {
            return ".";
        }
        return Unix.escapeSh((String)this.workDir.getAbsolutePath());
    }

    private String eol(String prefix) {
        if (prefix != null && prefix.charAt(prefix.length() - 1) == '\n') {
            return "";
        }
        return "\n";
    }
}

