/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.iisconfiguration.helper.ResourceHelper
import com.urbancode.air.plugin.iisconfiguration.helper.AppCmdCLIHelper
import com.urbancode.air.plugin.iisconfiguration.helper.TopologyDiscoveryHelper
import org.codehaus.jettison.json.JSONObject
import org.codehaus.jettison.json.JSONArray
import com.urbancode.air.plugin.iisconfiguration.Globals
import groovy.io.FileType

println("Starting topology discovery...")
final File PLUGIN_HOME = new File(System.getenv().get("PLUGIN_HOME"))
String DISCOVERY_PS_SCRIPT = "${PLUGIN_HOME.getCanonicalPath()}\\fullDiscovery.ps1"

//initialize plugin tools
def s = File.separator
def apTool = new AirPluginTool(args[0], args[1])
def props = apTool.getStepProperties()

//initialize ucd related variables
def ucdUsername = apTool.getAuthTokenUsername()
def ucdPassword = apTool.getAuthToken()
def ucdUri = new URI(System.getenv("AH_WEB_URL"))
def resourceHelper = new ResourceHelper(ucdUri, ucdUsername, ucdPassword)
def thisResourcePath = props['resourcePath']

//initialize iis related variables
def appCmdPath = props['appCmdPath']
def appCmdHelper = new AppCmdCLIHelper(appCmdPath)
def topologyDiscoveryHelper = new TopologyDiscoveryHelper(resourceHelper)

//main method
def main = {
    JSONArray fullJSON = new JSONArray()

    //if we are here then populate the resource tree with a topology
    //---SITES---
    def sites = appCmdHelper.listObjects(AppCmdCLIHelper.SITES)
    def sitesParentGroupName = "Sites"
    def sitesParentGroupPath = "${thisResourcePath}/${sitesParentGroupName}"
    println("Found sites: ${sites}")
    JSONArray sitesJSON = topologyDiscoveryHelper.extractToJSONArray(sites, thisResourcePath, sitesParentGroupPath, Globals.SITE_ROLE_NAME, "")

    //---APPS---
    def apps = appCmdHelper.listObjects(AppCmdCLIHelper.APPLICATIONS)
    def appsParentsGroupName = "Applications"
    def appsParentsGroupPath = "${thisResourcePath}/${appsParentsGroupName}"
    println("Found apps: ${apps}")
    JSONArray appsJSON = topologyDiscoveryHelper.extractToJSONArray(apps, thisResourcePath, appsParentsGroupPath, Globals.APP_ROLE_NAME, "")

    //---APP POOLS---
    def appPools = appCmdHelper.listObjects(AppCmdCLIHelper.APPLICATION_POOLS)
    def appPoolsParentsGroupName = "Application Pools"
    def appPoolsParentsGroupPath = "${thisResourcePath}/${appPoolsParentsGroupName}"
    println("Found appPools: ${appPools}")
    JSONArray appPoolsJSON = topologyDiscoveryHelper.extractToJSONArray(appPools, thisResourcePath, appPoolsParentsGroupPath, Globals.APP_POOL_ROLE_NAME, "")

    //create a Sites group to place all Sites underneath
    def sitesParentGroupResource = resourceHelper.getOrCreateSubResource(sitesParentGroupPath, thisResourcePath, sitesParentGroupName, "")
    topologyDiscoveryHelper.addResourcesToResourceTree(sitesJSON)

    //add Apps underneath the associated Sites
    topologyDiscoveryHelper.addResourcesToResourceTree(appsJSON)

    //add App Pools to resource tree to play all App Pools underneath
    def appPoolsParentsGroupResource = resourceHelper.getOrCreateSubResource(appPoolsParentsGroupPath, thisResourcePath, appPoolsParentsGroupName, "")
    topologyDiscoveryHelper.addResourcesToResourceTree(appPoolsJSON)

    //build master json for topology discovery
    topologyDiscoveryHelper.mergeJSONArrays(sitesJSON, fullJSON)
    topologyDiscoveryHelper.mergeJSONArrays(appsJSON, fullJSON)
    topologyDiscoveryHelper.mergeJSONArrays(appPoolsJSON, fullJSON)
    println("Configuration: \n${fullJSON.toString(4)}")
}

main()