/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2002-2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/

import groovy.util.AntBuilder

import com.urbancode.air.AirPluginTool
import com.urbancode.air.CommandHelper
import com.urbancode.air.plugin.iisconfiguration.helper.MSDeployCmdLineHelper
import com.urbancode.air.plugin.iisconfiguration.helper.FileUtilReplaceTokens
import com.urbancode.air.plugin.iisconfiguration.Globals
import com.urbancode.air.plugin.iisconfiguration.Util

//initialize plugin tools
def s = File.separator
def apTool = new AirPluginTool(args[0], args[1])
def isWindows = apTool.isWindows
def props = apTool.getStepProperties()
def fileUtilReplaceTokens = new FileUtilReplaceTokens()
def antBuilder = new AntBuilder()

//initialize ucd related variables
def ucdUsername = apTool.getAuthTokenUsername()
def ucdPassword = apTool.getAuthToken()
def ucdUri = new URI(System.getenv("AH_WEB_URL"))

def main = {
    //replace tokens
    fileUtilReplaceTokens.run(props, "")
}

main()
