/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.winapi;

import java.util.Locale;

public class WindowsUserName {
    private final String domain;
    private final String user;

    public static WindowsUserName parse(String user) {
        if (user == null) {
            throw new NullPointerException();
        }
        String domain = null;
        int i = user.indexOf(92);
        if (i != -1) {
            domain = user.substring(0, i);
            if (domain.length() == 0) {
                domain = null;
            }
            user = user.substring(i + 1);
        }
        return new WindowsUserName(domain, user);
    }

    public WindowsUserName(String domain, String user) {
        if (user == null) {
            throw new NullPointerException("user");
        }
        this.domain = domain;
        this.user = user;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getUser() {
        return this.user;
    }

    public boolean equals(Object obj) {
        if (obj instanceof WindowsUserName) {
            WindowsUserName rhs = (WindowsUserName)obj;
            return (this.domain == null ? rhs.domain == null : this.domain.toUpperCase(Locale.US).equals(rhs.domain.toUpperCase(Locale.US))) && this.user.equalsIgnoreCase(rhs.user);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 37;
        hashCode = 13 * hashCode + (this.domain != null ? 0 : this.domain.toUpperCase(Locale.US).hashCode());
        hashCode = 13 * hashCode + this.user.toUpperCase(Locale.US).hashCode();
        return hashCode;
    }

    public String toString() {
        if (this.domain == null) {
            return this.user;
        }
        return this.domain + "\\" + this.user;
    }
}

